import gdb


# offset from calle_save.psp
STACK_FRAME_OFFSETS = {
  "r0": 0,
  "r1": 4,
  "r2": 8,
  "r3": 12,
  "r12": 16,
  "lr": 20,  # r14
  "pc": 24,  # r15
}

# offset from *calle_saved.psp
CALLEE_SAVED_OFFSETS = {
  "r4": -32,
  "r5": -28,
  "r6": -24,
  "r7": -20,
  "r8": -16,
  "r9": -12,
  "r10": -8,
  "r11": -4,
}


def switch_zephyr_thread(self, stack_ptr):
    if self._saved_regs is not None:
        self.switch_thread_back()
    self.save_regs()
    self._stacking = self.get_thread_stacking(stack_ptr)

    sp = int(gdb.parse_and_eval("*(int *)" + str(stack_ptr)))
    gdb.execute("set $sp=" + str(sp + 32))  # 32 is exception frame size

    for reg_name, reg_offset in CALLEE_SAVED_OFFSETS.items():
        gdb.execute("set $" + reg_name + "=*(int *)" + str(stack_ptr + reg_offset))

    for reg_name, reg_offset in STACK_FRAME_OFFSETS.items():
        gdb.execute("set $" + reg_name + "=*(int *)" + str(sp + reg_offset))


# should be never called as soon as we override switch_thread
def get_arm_cm_zephyr_stacking(stack_ptr, uint32_type):
    return None
