/*****
 NAME
 	pguiparser.h - prototype for GUI-XML classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PGUIPARSER_H_INCLUDED)
#define PGUIPARSER_H_INCLUDED

#include <coconut/pobject.h>
#include <coconut/pxmlparser.h>
#include <coconut/gtk/pwidget.h>

@protocol PGUIParserPart <PXMLParserIF>
 - addWidget: (id <PWidget>) parent node: (id <PXMLNode>) node 
    widget: (id <PWidget>) newchild ;
 - addContainer: (id <PWidget>) parent node: (id <PXMLNode>) node ;

 - (screen_align_t) getScreenAlign: (id <PXMLNode>) node ;
   /* if the "layout" attribute is given with "holiz" value, return dir_right */
 - (direction_t) getLayout: (id <PXMLNode>) node ;

 - (id <PError>) setAlign: (id <PWidget>) widget node: (id <PXMLNode>) node
     valueId: (int) valueid ;
 - (id <PError>) setDirection: (id <PWidget>) widget node: (id <PXMLNode>) node
     valueId: (int) valueid ;
 - (id <PError>) setHomogeneous: (id <PWidget>) widget node: (id <PXMLNode>) 
     node valueId: (int) valueid ;
 - (id <PError>) setShadow: (id <PWidget>) widget node: (id <PXMLNode>) node
     valueId: (int) valueid ;
 - (id <PError>) setSpacing: (id <PWidget>) widget node: (id <PXMLNode>) node
     value: (id <PConstStr>) value ;
 - (id <PError>) setTitle: (id <PWidget>) widget node: (id <PXMLNode>) node
     value: (id <PConstStr>) value ;

 - (boolean) isContainer: (id <PWidget>) widget node: (id <PXMLNode>) node ;
@end

@protocol PGUIParser <PGUIParserPart, PXMLParserPart>
@end

@protocol PEventTable <PObject>
 - connectClickedEvent: (id <PWidget>) widget and: (id <PTree>) cmd 
     with: param ;
@end

#endif /* !defined(PGUIPARSER_H_INCLUDED) */

