/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;

public class TransportUpdateProcessAction
extends TransportJobTaskAction<UpdateProcessAction.Request, UpdateProcessAction.Response> {
    @Inject
    public TransportUpdateProcessAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager) {
        super(settings, "cluster:internal/xpack/ml/job/update/process", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateProcessAction.Request::new, UpdateProcessAction.Response::new, "same", processManager);
    }

    protected UpdateProcessAction.Response readTaskResponse(StreamInput in) throws IOException {
        UpdateProcessAction.Response response = new UpdateProcessAction.Response();
        response.readFrom(in);
        return response;
    }

    protected void taskOperation(UpdateProcessAction.Request request, TransportOpenJobAction.JobTask task, ActionListener<UpdateProcessAction.Response> listener) {
        UpdateParams updateParams = UpdateParams.builder(request.getJobId()).modelPlotConfig(request.getModelPlotConfig()).detectorUpdates(request.getDetectorUpdates()).filter(request.getFilter()).updateScheduledEvents(request.isUpdateScheduledEvents()).build();
        try {
            this.processManager.writeUpdateProcessMessage(task, updateParams, e -> {
                if (e == null) {
                    listener.onResponse((Object)new UpdateProcessAction.Response());
                } else {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

