/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryNumericFunction
extends BinaryScalarFunction {
    private final BinaryMathProcessor.BinaryMathOperation operation;

    BinaryNumericFunction(Source source, Expression left, Expression right, BinaryMathProcessor.BinaryMathOperation operation) {
        super(source, left, right);
        this.operation = operation;
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric(this.left(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric(this.right(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
    }

    @Override
    public Object fold() {
        return this.operation.apply((Number)this.left().fold(), (Number)this.right().fold());
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryMathPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), this.operation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryNumericFunction other = (BinaryNumericFunction)obj;
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right()) && Objects.equals(other.operation, this.operation);
    }
}

