/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class ArithmeticOperation
extends BinaryOperator<Object, Object, Object, BinaryArithmeticProcessor.BinaryArithmeticOperation> {
    private DataType dataType;

    protected ArithmeticOperation(Source source, Expression left, Expression right, BinaryArithmeticProcessor.BinaryArithmeticOperation operation) {
        super(source, left, right, operation);
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isNumeric(e, this.sourceText(), paramOrdinal);
    }

    public ArithmeticOperation swapLeftAndRight() {
        return this;
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = DataTypeConversion.commonType(this.left().dataType(), this.right().dataType());
        }
        return this.dataType;
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryArithmeticPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryArithmeticProcessor.BinaryArithmeticOperation)this.function());
    }
}

