/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureUtils;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;

public class NdJsonFileStructureFinder
implements FileStructureFinder {
    private final List<String> sampleMessages;
    private final FileStructure structure;

    static NdJsonFileStructureFinder makeNdJsonFileStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        ArrayList sampleRecords = new ArrayList();
        List<String> sampleMessages = Arrays.asList(sample.split("\n"));
        for (String sampleMessage : sampleMessages) {
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, sampleMessage);
            sampleRecords.add(parser.mapOrdered());
            timeoutChecker.check("NDJSON parsing");
        }
        FileStructure.Builder structureBuilder = new FileStructure.Builder(FileStructure.Format.NDJSON).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(sampleMessages.stream().limit(2L).collect(Collectors.joining("\n", "", "\n"))).setNumLinesAnalyzed(sampleMessages.size()).setNumMessagesAnalyzed(sampleRecords.size());
        Tuple<String, TimestampFormatFinder.TimestampMatch> timeField = FileStructureUtils.guessTimestampField(explanation, sampleRecords, overrides, timeoutChecker);
        if (timeField != null) {
            boolean needClientTimeZone = ((TimestampFormatFinder.TimestampMatch)timeField.v2()).hasTimezoneDependentParsing();
            structureBuilder.setTimestampField((String)timeField.v1()).setJodaTimestampFormats(((TimestampFormatFinder.TimestampMatch)timeField.v2()).jodaTimestampFormats).setJavaTimestampFormats(((TimestampFormatFinder.TimestampMatch)timeField.v2()).javaTimestampFormats).setNeedClientTimezone(needClientTimeZone).setIngestPipeline(FileStructureUtils.makeIngestPipelineDefinition(null, (String)timeField.v1(), ((TimestampFormatFinder.TimestampMatch)timeField.v2()).javaTimestampFormats, needClientTimeZone));
        }
        Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> mappingsAndFieldStats = FileStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker);
        SortedMap mappings = (SortedMap)mappingsAndFieldStats.v1();
        if (timeField != null) {
            mappings.put("@timestamp", Collections.singletonMap("type", "date"));
        }
        if (mappingsAndFieldStats.v2() != null) {
            structureBuilder.setFieldStats((Map)mappingsAndFieldStats.v2());
        }
        FileStructure structure = structureBuilder.setMappings((Map)mappings).setExplanation(explanation).build();
        return new NdJsonFileStructureFinder(sampleMessages, structure);
    }

    private NdJsonFileStructureFinder(List<String> sampleMessages, FileStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public FileStructure getStructure() {
        return this.structure;
    }
}

