/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.filter;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

public class RestPutFilterAction
extends BaseRestHandler {
    public RestPutFilterAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/ml/filters/{" + MlFilter.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_ml/filters/{" + MlFilter.ID.getPreferredName() + "}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_put_filter_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String filterId = restRequest.param(MlFilter.ID.getPreferredName());
        XContentParser parser = restRequest.contentOrSourceParamParser();
        PutFilterAction.Request putFilterRequest = PutFilterAction.Request.parseRequest((String)filterId, (XContentParser)parser);
        return channel -> client.execute((Action)PutFilterAction.INSTANCE, (ActionRequest)putFilterRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

