/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyResponse;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportGetApiKeyAction
extends HandledTransportAction<GetApiKeyRequest, GetApiKeyResponse> {
    private final ApiKeyService apiKeyService;

    @Inject
    public TransportGetApiKeyAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/security/api_key/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
    }

    protected void doExecute(GetApiKeyRequest request, ActionListener<GetApiKeyResponse> listener) {
        if (Strings.hasText((String)request.getRealmName()) || Strings.hasText((String)request.getUserName())) {
            this.apiKeyService.getApiKeysForRealmAndUser(request.getRealmName(), request.getUserName(), listener);
        } else if (Strings.hasText((String)request.getApiKeyId())) {
            this.apiKeyService.getApiKeyForApiKeyId(request.getApiKeyId(), listener);
        } else if (Strings.hasText((String)request.getApiKeyName())) {
            this.apiKeyService.getApiKeyForApiKeyName(request.getApiKeyName(), listener);
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("One of [api key id, api key name, username, realm name] must be specified"));
        }
    }
}

