/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.whitelist;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NamedDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.MathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BinaryStringNumericProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BinaryStringStringProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.literal.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.logical.NotProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.CheckNullProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.UnaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.regex.RegexProcessor;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.util.DateUtils;

public final class InternalSqlScriptUtils {
    private InternalSqlScriptUtils() {
    }

    public static <T> Object docValue(Map<String, ScriptDocValues<T>> doc, String fieldName) {
        ScriptDocValues<T> docValues;
        if (doc.containsKey(fieldName) && !(docValues = doc.get(fieldName)).isEmpty()) {
            return docValues.get(0);
        }
        return null;
    }

    public static boolean nullSafeFilter(Boolean filter) {
        return filter == null ? false : filter;
    }

    public static double nullSafeSortNumeric(Number sort) {
        return sort == null ? 0.0 : sort.doubleValue();
    }

    public static String nullSafeSortString(Object sort) {
        return sort == null ? "" : sort.toString();
    }

    public static Boolean eq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.EQ.apply(left, right);
    }

    public static Boolean nulleq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.NULLEQ.apply(left, right);
    }

    public static Boolean neq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.NEQ.apply(left, right);
    }

    public static Boolean lt(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.LT.apply(left, right);
    }

    public static Boolean lte(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.LTE.apply(left, right);
    }

    public static Boolean gt(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.GT.apply(left, right);
    }

    public static Boolean gte(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.GTE.apply(left, right);
    }

    public static Boolean and(Boolean left, Boolean right) {
        return BinaryLogicProcessor.BinaryLogicOperation.AND.apply(left, right);
    }

    public static Boolean or(Boolean left, Boolean right) {
        return BinaryLogicProcessor.BinaryLogicOperation.OR.apply(left, right);
    }

    public static Boolean not(Boolean expression) {
        return NotProcessor.apply(expression);
    }

    public static Boolean isNull(Object expression) {
        return CheckNullProcessor.CheckNullOperation.IS_NULL.apply(expression);
    }

    public static Boolean isNotNull(Object expression) {
        return CheckNullProcessor.CheckNullOperation.IS_NOT_NULL.apply(expression);
    }

    public static Boolean in(Object value, List<Object> values) {
        return InProcessor.apply(value, values);
    }

    public static Object coalesce(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.COALESCE.apply((Collection<Object>)expressions);
    }

    public static Object greatest(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.GREATEST.apply((Collection<Object>)expressions);
    }

    public static Object least(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.LEAST.apply((Collection<Object>)expressions);
    }

    public static Object nullif(Object left, Object right) {
        return NullIfProcessor.apply(left, right);
    }

    public static Boolean regex(String value, String pattern) {
        return RegexProcessor.RegexOperation.match((Object)value, pattern);
    }

    public static Object add(Object left, Object right) {
        return BinaryArithmeticProcessor.BinaryArithmeticOperation.ADD.apply(left, right);
    }

    public static Object div(Object left, Object right) {
        return BinaryArithmeticProcessor.BinaryArithmeticOperation.DIV.apply(left, right);
    }

    public static Object mod(Object left, Object right) {
        return BinaryArithmeticProcessor.BinaryArithmeticOperation.MOD.apply(left, right);
    }

    public static Object mul(Object left, Object right) {
        return BinaryArithmeticProcessor.BinaryArithmeticOperation.MUL.apply(left, right);
    }

    public static Number neg(Number value) {
        return UnaryArithmeticProcessor.UnaryArithmeticOperation.NEGATE.apply(value);
    }

    public static Object sub(Object left, Object right) {
        return BinaryArithmeticProcessor.BinaryArithmeticOperation.SUB.apply(left, right);
    }

    public static Number round(Number v, Number s) {
        return BinaryOptionalMathProcessor.BinaryOptionalMathOperation.ROUND.apply(v, s);
    }

    public static Number truncate(Number v, Number s) {
        return BinaryOptionalMathProcessor.BinaryOptionalMathOperation.TRUNCATE.apply(v, s);
    }

    public static Double abs(Number value) {
        return MathProcessor.MathOperation.ABS.apply(value);
    }

    public static Double acos(Number value) {
        return MathProcessor.MathOperation.ACOS.apply(value);
    }

    public static Double asin(Number value) {
        return MathProcessor.MathOperation.ASIN.apply(value);
    }

    public static Double atan(Number value) {
        return MathProcessor.MathOperation.ATAN.apply(value);
    }

    public static Number atan2(Number left, Number right) {
        return BinaryMathProcessor.BinaryMathOperation.ATAN2.apply(left, right);
    }

    public static Double cbrt(Number value) {
        return MathProcessor.MathOperation.CBRT.apply(value);
    }

    public static Double ceil(Number value) {
        return MathProcessor.MathOperation.CEIL.apply(value);
    }

    public static Double cos(Number value) {
        return MathProcessor.MathOperation.COS.apply(value);
    }

    public static Double cosh(Number value) {
        return MathProcessor.MathOperation.COSH.apply(value);
    }

    public static Double cot(Number value) {
        return MathProcessor.MathOperation.COT.apply(value);
    }

    public static Double degrees(Number value) {
        return MathProcessor.MathOperation.DEGREES.apply(value);
    }

    public static Double e(Number value) {
        return MathProcessor.MathOperation.E.apply(value);
    }

    public static Double exp(Number value) {
        return MathProcessor.MathOperation.EXP.apply(value);
    }

    public static Double expm1(Number value) {
        return MathProcessor.MathOperation.EXPM1.apply(value);
    }

    public static Double floor(Number value) {
        return MathProcessor.MathOperation.FLOOR.apply(value);
    }

    public static Double log(Number value) {
        return MathProcessor.MathOperation.LOG.apply(value);
    }

    public static Double log10(Number value) {
        return MathProcessor.MathOperation.LOG10.apply(value);
    }

    public static Double pi(Number value) {
        return MathProcessor.MathOperation.PI.apply(value);
    }

    public static Number power(Number left, Number right) {
        return BinaryMathProcessor.BinaryMathOperation.POWER.apply(left, right);
    }

    public static Double radians(Number value) {
        return MathProcessor.MathOperation.RADIANS.apply(value);
    }

    public static Double random(Number value) {
        return MathProcessor.MathOperation.RANDOM.apply(value);
    }

    public static Double sign(Number value) {
        return MathProcessor.MathOperation.SIGN.apply(value);
    }

    public static Double sin(Number value) {
        return MathProcessor.MathOperation.SIN.apply(value);
    }

    public static Double sinh(Number value) {
        return MathProcessor.MathOperation.SINH.apply(value);
    }

    public static Double sqrt(Number value) {
        return MathProcessor.MathOperation.SQRT.apply(value);
    }

    public static Double tan(Number value) {
        return MathProcessor.MathOperation.TAN.apply(value);
    }

    public static Integer dateTimeChrono(Object dateTime, String tzId, String chronoName) {
        if (dateTime == null || tzId == null || chronoName == null) {
            return null;
        }
        return DateTimeFunction.dateTimeChrono(InternalSqlScriptUtils.asDateTime(dateTime), tzId, chronoName);
    }

    public static String dayName(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NamedDateTimeProcessor.NameExtractor.DAY_NAME.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer dayOfWeek(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.DAY_OF_WEEK.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static String monthName(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NamedDateTimeProcessor.NameExtractor.MONTH_NAME.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer quarter(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return QuarterProcessor.quarter(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer weekOfYear(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.WEEK_OF_YEAR.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static ZonedDateTime asDateTime(Object dateTime) {
        return (ZonedDateTime)InternalSqlScriptUtils.asDateTime(dateTime, false);
    }

    private static Object asDateTime(Object dateTime, boolean lenient) {
        if (dateTime == null) {
            return null;
        }
        if (dateTime instanceof JodaCompatibleZonedDateTime) {
            return ((JodaCompatibleZonedDateTime)dateTime).getZonedDateTime();
        }
        if (dateTime instanceof ZonedDateTime) {
            return dateTime;
        }
        if (!lenient) {
            if (dateTime instanceof Number) {
                return DateUtils.asDateTime(((Number)dateTime).longValue());
            }
            if (dateTime instanceof String) {
                return DateUtils.asDateTime(dateTime.toString());
            }
            throw new SqlIllegalArgumentException("Invalid date encountered [{}]", dateTime);
        }
        return dateTime;
    }

    public static IntervalDayTime intervalDayTime(String text, String typeName) {
        if (text == null || typeName == null) {
            return null;
        }
        return new IntervalDayTime(Duration.parse(text), DataType.fromTypeName(typeName));
    }

    public static IntervalYearMonth intervalYearMonth(String text, String typeName) {
        if (text == null || typeName == null) {
            return null;
        }
        return new IntervalYearMonth(Period.parse(text), DataType.fromTypeName(typeName));
    }

    public static Integer ascii(String s) {
        return (Integer)StringProcessor.StringOperation.ASCII.apply(s);
    }

    public static Integer bitLength(String s) {
        return (Integer)StringProcessor.StringOperation.BIT_LENGTH.apply(s);
    }

    public static String character(Number n) {
        return (String)StringProcessor.StringOperation.CHAR.apply(n);
    }

    public static Integer charLength(String s) {
        return (Integer)StringProcessor.StringOperation.CHAR_LENGTH.apply(s);
    }

    public static String concat(String s1, String s2) {
        return (String)ConcatFunctionProcessor.process(s1, s2);
    }

    public static String insert(String s, Number start, Number length, String r) {
        return (String)InsertFunctionProcessor.doProcess(s, start, length, r);
    }

    public static String lcase(String s) {
        return (String)StringProcessor.StringOperation.LCASE.apply(s);
    }

    public static String left(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.LEFT.apply(s, count);
    }

    public static Integer length(String s) {
        return (Integer)StringProcessor.StringOperation.LENGTH.apply(s);
    }

    public static Integer locate(String s1, String s2) {
        return InternalSqlScriptUtils.locate(s1, s2, null);
    }

    public static Integer locate(String s1, String s2, Number pos) {
        return LocateFunctionProcessor.doProcess(s1, s2, pos);
    }

    public static String ltrim(String s) {
        return (String)StringProcessor.StringOperation.LTRIM.apply(s);
    }

    public static Integer octetLength(String s) {
        return (Integer)StringProcessor.StringOperation.OCTET_LENGTH.apply(s);
    }

    public static Integer position(String s1, String s2) {
        return (Integer)BinaryStringStringProcessor.BinaryStringStringOperation.POSITION.apply(s1, s2);
    }

    public static String repeat(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.REPEAT.apply(s, count);
    }

    public static String replace(String s1, String s2, String s3) {
        return (String)ReplaceFunctionProcessor.doProcess(s1, s2, s3);
    }

    public static String right(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.RIGHT.apply(s, count);
    }

    public static String rtrim(String s) {
        return (String)StringProcessor.StringOperation.RTRIM.apply(s);
    }

    public static String space(Number n) {
        return (String)StringProcessor.StringOperation.SPACE.apply(n);
    }

    public static String substring(String s, Number start, Number length) {
        return (String)SubstringFunctionProcessor.doProcess(s, start, length);
    }

    public static String ucase(String s) {
        return (String)StringProcessor.StringOperation.UCASE.apply(s);
    }

    public static Object cast(Object value, String typeName) {
        return DataTypeConversion.convert(InternalSqlScriptUtils.asDateTime(value, true), DataType.fromTypeName(typeName));
    }
}

