/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.regex;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class RegexMatch<T>
extends UnaryScalarFunction {
    private final T pattern;

    protected RegexMatch(Source source, Expression value, T pattern) {
        super(source, value);
        this.pattern = pattern;
    }

    public T pattern() {
        return this.pattern;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        if (this.pattern() == null) {
            return Nullability.TRUE;
        }
        return this.field().nullable();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isStringAndExact(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(((RegexMatch)obj).pattern(), this.pattern());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern());
    }
}

