/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.Check;

public class Schema
implements Iterable<Entry> {
    public static final Schema EMPTY = new Schema(Collections.emptyList(), Collections.emptyList());
    private final List<String> names;
    private final List<DataType> types;

    public Schema(List<String> names, List<DataType> types) {
        Check.isTrue(names.size() == types.size(), "Different # of names {} vs types {}", names, types);
        this.types = types;
        this.names = names;
    }

    public List<String> names() {
        return this.names;
    }

    public List<DataType> types() {
        return this.types;
    }

    public int size() {
        return this.names.size();
    }

    public Entry get(int i) {
        return new DefaultEntry(this.names.get(i), this.types.get(i));
    }

    public DataType type(String name) {
        int indexOf = this.names.indexOf(name);
        if (indexOf < 0) {
            return null;
        }
        return this.types.get(indexOf);
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            private final int size;
            private int pos;
            {
                this.size = Schema.this.size();
                this.pos = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size - 1;
            }

            @Override
            public Entry next() {
                if (this.pos++ >= this.size) {
                    throw new NoSuchElementException();
                }
                return Schema.this.get(this.pos);
            }
        };
    }

    public Stream<Entry> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Spliterator<Entry> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.names.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.names.get(i));
            sb.append(":");
            sb.append(this.types.get((int)i).typeName);
        }
        sb.append("]");
        return sb.toString();
    }

    static class DefaultEntry
    implements Entry {
        private final String name;
        private final DataType type;

        DefaultEntry(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public DataType type() {
            return this.type;
        }
    }

    public static interface Entry {
        public String name();

        public DataType type();
    }
}

