/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;

public final class SearchGroupsResolverSettings {
    public static final Setting<String> BASE_DN = Setting.simpleString((String)"group_search.base_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<LdapSearchScope> SCOPE = new Setting("group_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> USER_ATTRIBUTE = Setting.simpleString((String)"group_search.user_attribute", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))";
    public static final Setting<String> FILTER = new Setting("group_search.filter", "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});

    private SearchGroupsResolverSettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(BASE_DN);
        settings.add(FILTER);
        settings.add(USER_ATTRIBUTE);
        settings.add(SCOPE);
        return settings;
    }
}

