/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class ReservedRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final RoleDescriptor SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("*").privileges("*").resources("*").build()}, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Collections.emptyMap());
    public static final Role SUPERUSER_ROLE = Role.builder(SUPERUSER_ROLE_DESCRIPTOR, null).build();
    private static final Map<String, RoleDescriptor> RESERVED_ROLES = ReservedRolesStore.initializeReservedRoles();

    private static Map<String, RoleDescriptor> initializeReservedRoles() {
        return MapBuilder.newMapBuilder().put((Object)"superuser", (Object)SUPERUSER_ROLE_DESCRIPTOR).put((Object)"transport_client", (Object)new RoleDescriptor("transport_client", new String[]{"transport_client"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_user", (Object)new RoleDescriptor("kibana_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("manage", "read", "index", "delete").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"monitoring_user", (Object)new RoleDescriptor("monitoring_user", new String[]{"cluster:monitor/main", "cluster:monitor/xpack/info"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"remote_monitoring_agent", (Object)new RoleDescriptor("remote_monitoring_agent", new String[]{"manage_index_templates", "manage_ingest_pipelines", "monitor", "cluster:monitor/xpack/watcher/watch/get", "cluster:admin/xpack/watcher/watch/put", "cluster:admin/xpack/watcher/watch/delete"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("index", "create_index").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"remote_monitoring_collector", (Object)new RoleDescriptor("remote_monitoring_collector", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"ingest_admin", (Object)new RoleDescriptor("ingest_admin", new String[]{"manage_index_templates", "manage_pipeline"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"reporting_user", (Object)new RoleDescriptor("reporting_user", null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_dashboard_only_user", (Object)new RoleDescriptor("kibana_dashboard_only_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("read").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"kibana_system", (Object)new RoleDescriptor("kibana_system", new String[]{"monitor", "manage_index_templates", "cluster:admin/xpack/monitoring/bulk", "manage_saml", "manage_token"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*", ".reporting-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("create_index", "read", "write").build()}, null, new ConditionalClusterPrivilege[]{new ConditionalClusterPrivileges.ManageApplicationPrivileges(Collections.singleton("kibana-*"))}, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"logstash_system", (Object)new RoleDescriptor("logstash_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"beats_admin", (Object)new RoleDescriptor("beats_admin", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"beats_system", (Object)new RoleDescriptor("beats_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"apm_system", (Object)new RoleDescriptor("apm_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"machine_learning_user", (Object)new RoleDescriptor("machine_learning_user", new String[]{"monitor_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"machine_learning_admin", (Object)new RoleDescriptor("machine_learning_admin", new String[]{"manage_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*", ".ml-state*", ".ml-meta*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"watcher_admin", (Object)new RoleDescriptor("watcher_admin", new String[]{"manage_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches", ".triggered_watches", ".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"watcher_user", (Object)new RoleDescriptor("watcher_user", new String[]{"monitor_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"logstash_admin", (Object)new RoleDescriptor("logstash_admin", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".logstash*").privileges("create", "delete", "index", "manage", "read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"rollup_user", (Object)new RoleDescriptor("rollup_user", new String[]{"monitor_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"rollup_admin", (Object)new RoleDescriptor("rollup_admin", new String[]{"manage_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"snapshot_user", (Object)new RoleDescriptor("snapshot_user", new String[]{"create_snapshot", "cluster:admin/repository/get"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).immutableMap();
    }

    public static boolean isReserved(String role) {
        return RESERVED_ROLES.containsKey(role) || "_system".equals(role) || "_xpack".equals(role);
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        return RESERVED_ROLES.get(role);
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        return RESERVED_ROLES.values();
    }

    public static Set<String> names() {
        return RESERVED_ROLES.keySet();
    }

    @Override
    public void accept(Set<String> roleNames, ActionListener<RoleRetrievalResult> listener) {
        Set<RoleDescriptor> descriptors = roleNames.stream().map(RESERVED_ROLES::get).filter(Objects::nonNull).collect(Collectors.toSet());
        listener.onResponse((Object)RoleRetrievalResult.success(descriptors));
    }

    public String toString() {
        return "reserved roles store";
    }
}

