/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PassphraseEncryptedInputStream
extends InputStream {
    private final CipherInputStream cipherInputStream;
    private final PassphraseEncryptedStreamHeader encryptionHeader;

    public PassphraseEncryptedInputStream(String passphrase, InputStream wrappedInputStream) throws IOException, LDAPException, InvalidKeyException, GeneralSecurityException {
        this(passphrase.toCharArray(), wrappedInputStream);
    }

    public PassphraseEncryptedInputStream(char[] passphrase, InputStream wrappedInputStream) throws IOException, LDAPException, InvalidKeyException, GeneralSecurityException {
        this(wrappedInputStream, PassphraseEncryptedStreamHeader.readFrom(wrappedInputStream, passphrase));
    }

    public PassphraseEncryptedInputStream(InputStream wrappedInputStream, PassphraseEncryptedStreamHeader encryptionHeader) throws GeneralSecurityException {
        this.encryptionHeader = encryptionHeader;
        Cipher cipher = encryptionHeader.createCipher(2);
        this.cipherInputStream = new CipherInputStream(wrappedInputStream, cipher);
    }

    @Override
    public int read() throws IOException {
        return this.cipherInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.cipherInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.cipherInputStream.read(b, offset, length);
    }

    @Override
    public long skip(long maxBytesToSkip) throws IOException {
        return this.cipherInputStream.skip(maxBytesToSkip);
    }

    @Override
    public int available() throws IOException {
        return this.cipherInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.cipherInputStream.close();
    }

    @Override
    public boolean markSupported() {
        return this.cipherInputStream.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        this.cipherInputStream.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.cipherInputStream.reset();
    }

    public PassphraseEncryptedStreamHeader getEncryptionHeader() {
        return this.encryptionHeader;
    }
}

