/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class BooleanArgument
extends Argument {
    private static final long serialVersionUID = -3366354214909534696L;

    public BooleanArgument(Character shortIdentifier, String longIdentifier, String description) throws ArgumentException {
        super(shortIdentifier, longIdentifier, false, 1, null, description);
    }

    public BooleanArgument(Character shortIdentifier, String longIdentifier, int maxOccurrences, String description) throws ArgumentException {
        super(shortIdentifier, longIdentifier, false, maxOccurrences, null, description);
    }

    private BooleanArgument(BooleanArgument source) {
        super(source);
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        throw new ArgumentException(ArgsMessages.ERR_BOOLEAN_VALUES_NOT_ALLOWED.get(this.getIdentifierString()));
    }

    @Override
    public List<String> getValueStringRepresentations(boolean useDefault) {
        return Collections.singletonList(String.valueOf(this.isPresent()));
    }

    @Override
    protected boolean hasDefaultValue() {
        return false;
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_BOOLEAN_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_BOOLEAN_CONSTRAINTS.get();
    }

    @Override
    public BooleanArgument getCleanCopy() {
        return new BooleanArgument(this);
    }

    @Override
    protected void addToCommandLine(List<String> argStrings) {
        for (int i = 0; i < this.getNumOccurrences(); ++i) {
            argStrings.add(this.getIdentifierString());
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("BooleanArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(')');
    }
}

