/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public class ScheduleRegistry {
    private final Map<String, Schedule.Parser> parsers = new HashMap<String, Schedule.Parser>();

    public ScheduleRegistry(Set<Schedule.Parser> parsers) {
        parsers.stream().forEach(parser -> this.parsers.put(parser.type(), (Schedule.Parser)parser));
    }

    public Set<String> types() {
        return this.parsers.keySet();
    }

    public Schedule parse(String context, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        Schedule schedule = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type != null) {
                schedule = this.parse(context, type, parser);
                continue;
            }
            throw new ElasticsearchParseException("could not parse schedule. expected a schedule type field, but found [{}] instead", new Object[]{token});
        }
        if (schedule == null) {
            throw new ElasticsearchParseException("could not parse schedule. expected a schedule type field, but no fields were found", new Object[0]);
        }
        return schedule;
    }

    public Schedule parse(String context, String type, XContentParser parser) throws IOException {
        Schedule.Parser scheduleParser = this.parsers.get(type);
        if (scheduleParser == null) {
            throw new ElasticsearchParseException("could not parse schedule for [{}]. unknown schedule type [{}]", new Object[]{context, type});
        }
        return scheduleParser.parse(parser);
    }
}

