/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.GeneralAlternativeNameExtension;
import com.unboundid.util.ssl.cert.GeneralNames;
import com.unboundid.util.ssl.cert.X509CertificateExtension;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IssuerAlternativeNameExtension
extends GeneralAlternativeNameExtension {
    public static final OID ISSUER_ALTERNATIVE_NAME_OID = new OID("2.5.29.18");
    private static final long serialVersionUID = -1448132657790331913L;

    IssuerAlternativeNameExtension(boolean isCritical, GeneralNames generalNames) throws CertException {
        super(ISSUER_ALTERNATIVE_NAME_OID, isCritical, generalNames);
    }

    IssuerAlternativeNameExtension(X509CertificateExtension extension) throws CertException {
        super(extension);
    }

    @Override
    public String getExtensionName() {
        return CertMessages.INFO_ISSUER_ALT_NAME_EXTENSION_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        this.toString("IssuerAlternativeNameExtension", buffer);
    }
}

