/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStoreable;

final class PSubArrayLength
extends AStoreable {
    private final String type;
    private final String value;

    PSubArrayLength(Location location, String type, String value) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        if ("length".equals(this.value)) {
            if (this.write) {
                throw this.createError(new IllegalArgumentException("Cannot write to read-only field [length] for an array."));
            }
        } else {
            throw this.createError(new IllegalArgumentException("Field [" + this.value + "] does not exist for type [" + this.type + "]."));
        }
        this.actual = Integer.TYPE;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.arrayLength();
    }

    @Override
    int accessElementCount() {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    boolean isDefOptimized() {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix);
    }
}

