/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestPutLicenseAction
extends XPackRestHandler {
    private static final Logger logger = LogManager.getLogger(RestPutLicenseAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestPutLicenseAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/license", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_license", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/license", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_license", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_licenses", (RestHandler)this, "[POST /_licenses] is deprecated! Use [POST /_xpack/license] instead.", deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_licenses", (RestHandler)this, "[PUT /_licenses] is deprecated! Use [PUT /_xpack/license] instead.", deprecationLogger);
    }

    public String getName() {
        return "xpack_put_license_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        if (!request.hasContent()) {
            throw new IllegalArgumentException("The license must be provided in the request body");
        }
        PutLicenseRequest putLicenseRequest = new PutLicenseRequest();
        putLicenseRequest.license(request.content(), request.getXContentType());
        putLicenseRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        putLicenseRequest.timeout(request.paramAsTime("timeout", putLicenseRequest.timeout()));
        putLicenseRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putLicenseRequest.masterNodeTimeout()));
        if ("basic".equals(putLicenseRequest.license().type())) {
            throw new IllegalArgumentException("Installing basic licenses is no longer allowed. Use the POST /_xpack/license/start_basic API to install a basic license that does not expire.");
        }
        return channel -> client.es().admin().cluster().execute((Action)PutLicenseAction.INSTANCE, (ActionRequest)putLicenseRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

