/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class X509KeyPairSettings {
    static final Function<String, Setting<Optional<String>>> KEYSTORE_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, SSLConfigurationSettings.propertiesFromKey(key));
    static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEYSTORE_PASSWORD_TEMPLATE = key -> {
        Setting.Property[] propertyArray;
        if (key.startsWith("xpack.ssl.")) {
            Setting.Property[] propertyArray2 = new Setting.Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = Setting.Property.Deprecated;
        } else {
            propertyArray = new Setting.Property[]{};
        }
        return SecureSetting.secureString((String)key, LEGACY_KEYSTORE_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_password", "keystore.password")), (Setting.Property[])propertyArray);
    };
    static final Function<String, Setting<String>> KEY_STORE_ALGORITHM_TEMPLATE = key -> new Setting(key, s -> KeyManagerFactory.getDefaultAlgorithm(), Function.identity(), SSLConfigurationSettings.propertiesFromKey(key));
    static final Function<String, Setting<Optional<String>>> KEY_STORE_TYPE_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, SSLConfigurationSettings.propertiesFromKey(key));
    static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> {
        Setting.Property[] propertyArray;
        if (key.startsWith("xpack.ssl.")) {
            Setting.Property[] propertyArray2 = new Setting.Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = Setting.Property.Deprecated;
        } else {
            propertyArray = new Setting.Property[]{};
        }
        return SecureSetting.secureString((String)key, LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_key_password", "keystore.key_password")), (Setting.Property[])propertyArray);
    };
    static final Function<String, Setting<Optional<String>>> KEY_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, SSLConfigurationSettings.propertiesFromKey(key));
    static final Function<String, Setting<Optional<String>>> CERT_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, SSLConfigurationSettings.propertiesFromKey(key));
    static final Function<String, Setting<SecureString>> LEGACY_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEY_PASSWORD_TEMPLATE = key -> {
        Setting.Property[] propertyArray;
        if (key.startsWith("xpack.ssl.")) {
            Setting.Property[] propertyArray2 = new Setting.Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = Setting.Property.Deprecated;
        } else {
            propertyArray = new Setting.Property[]{};
        }
        return SecureSetting.secureString((String)key, LEGACY_KEY_PASSWORD_TEMPLATE.apply(key.replace("secure_key_passphrase", "key_passphrase")), (Setting.Property[])propertyArray);
    };
    private final String prefix;
    public final Setting<Optional<String>> keystorePath;
    public final Setting<SecureString> keystorePassword;
    public final Setting<String> keystoreAlgorithm;
    public final Setting<Optional<String>> keystoreType;
    public final Setting<SecureString> keystoreKeyPassword;
    public final Setting<Optional<String>> keyPath;
    public final Setting<SecureString> keyPassword;
    public final Setting<Optional<String>> certificatePath;
    public final Setting<SecureString> legacyKeystorePassword;
    public final Setting<SecureString> legacyKeystoreKeyPassword;
    public final Setting<SecureString> legacyKeyPassword;
    private final List<Setting<?>> allSettings;

    public X509KeyPairSettings(String prefix, boolean acceptNonSecurePasswords) {
        this.keystorePath = KEYSTORE_PATH_TEMPLATE.apply(prefix + "keystore.path");
        this.keystorePassword = KEYSTORE_PASSWORD_TEMPLATE.apply(prefix + "keystore.secure_password");
        this.keystoreAlgorithm = KEY_STORE_ALGORITHM_TEMPLATE.apply(prefix + "keystore.algorithm");
        this.keystoreType = KEY_STORE_TYPE_TEMPLATE.apply(prefix + "keystore.type");
        this.keystoreKeyPassword = KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(prefix + "keystore.secure_key_password");
        this.keyPath = KEY_PATH_TEMPLATE.apply(prefix + "key");
        this.keyPassword = KEY_PASSWORD_TEMPLATE.apply(prefix + "secure_key_passphrase");
        this.certificatePath = CERT_TEMPLATE.apply(prefix + "certificate");
        this.legacyKeystorePassword = LEGACY_KEYSTORE_PASSWORD_TEMPLATE.apply(prefix + "keystore.password");
        this.legacyKeystoreKeyPassword = LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(prefix + "keystore.key_password");
        this.legacyKeyPassword = LEGACY_KEY_PASSWORD_TEMPLATE.apply(prefix + "key_passphrase");
        this.prefix = prefix;
        ArrayList settings = CollectionUtils.arrayAsArrayList((Object[])new Setting[]{this.keystorePath, this.keystorePassword, this.keystoreAlgorithm, this.keystoreType, this.keystoreKeyPassword, this.keyPath, this.keyPassword, this.certificatePath});
        if (acceptNonSecurePasswords) {
            settings.add(this.legacyKeystorePassword);
            settings.add(this.legacyKeystoreKeyPassword);
            settings.add(this.legacyKeyPassword);
        }
        this.allSettings = Collections.unmodifiableList(settings);
    }

    public Collection<? extends Setting<?>> getAllSettings() {
        return this.allSettings;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

