/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnresolvedRelation;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    private PreAnalysis doPreAnalyze(LogicalPlan plan) {
        ArrayList<TableIdentifier> indices = new ArrayList<TableIdentifier>();
        plan.forEachUp(p -> indices.add(p.table()), UnresolvedRelation.class);
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indices);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(Collections.emptyList());
        public final List<TableIdentifier> indices;

        PreAnalysis(List<TableIdentifier> indices) {
            this.indices = indices;
        }
    }
}

