/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.List;
import org.elasticsearch.xpack.sql.execution.search.PagingListCursor;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.ListRowSet;
import org.elasticsearch.xpack.sql.type.Schema;

class PagingListRowSet
extends ListRowSet {
    private final int pageSize;
    private final int columnCount;
    private final Cursor cursor;

    PagingListRowSet(List<List<?>> list, int columnCount, int pageSize) {
        this(Schema.EMPTY, list, columnCount, pageSize);
    }

    PagingListRowSet(Schema schema, List<List<?>> list, int columnCount, int pageSize) {
        super(schema, list);
        this.columnCount = columnCount;
        this.pageSize = Math.min(pageSize, list.size());
        this.cursor = list.size() > pageSize ? new PagingListCursor(list, columnCount, pageSize) : Cursor.EMPTY;
    }

    @Override
    public int size() {
        return this.pageSize;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public Cursor nextPageCursor() {
        return this.cursor;
    }
}

