/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.logical;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogicPipe;
import org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryLogic
extends BinaryOperator<Boolean, Boolean, Boolean, BinaryLogicProcessor.BinaryLogicOperation> {
    protected BinaryLogic(Source source, Expression left, Expression right, BinaryLogicProcessor.BinaryLogicOperation operation) {
        super(source, left, right, operation);
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isBoolean(e, this.sourceText(), paramOrdinal);
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryLogicPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryLogicProcessor.BinaryLogicOperation)this.function());
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }
}

