/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.AbstractTaskFilePropertyRegistration;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertyRegistration;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.CompileClasspathNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.properties.StaticValue;

@NonNullApi
public class DefaultTaskInputFilePropertyRegistration
extends AbstractTaskFilePropertyRegistration
implements TaskInputFilePropertyRegistration {
    private final InputFilePropertyType filePropertyType;
    private boolean skipWhenEmpty;
    private DirectorySensitivity directorySensitivity = DirectorySensitivity.DEFAULT;
    private LineEndingSensitivity lineEndingSensitivity = LineEndingSensitivity.DEFAULT;
    private FileNormalizer normalizer = InputNormalizer.ABSOLUTE_PATH;

    public DefaultTaskInputFilePropertyRegistration(StaticValue value, InputFilePropertyType filePropertyType) {
        super(value);
        this.filePropertyType = filePropertyType;
    }

    @Override
    public InputFilePropertyType getFilePropertyType() {
        return this.filePropertyType;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    @Override
    public boolean isSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty(boolean skipWhenEmpty) {
        this.skipWhenEmpty = skipWhenEmpty;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty() {
        return this.skipWhenEmpty(true);
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional(boolean optional) {
        this.setOptional(optional);
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional() {
        return this.optional(true);
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathSensitivity(PathSensitivity sensitivity) {
        return this.withInternalNormalizer(InputNormalizer.determineNormalizerForPathSensitivity((PathSensitivity)sensitivity));
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withNormalizer(Class<? extends org.gradle.api.tasks.FileNormalizer> normalizer) {
        if (normalizer == ClasspathNormalizer.class) {
            return this.withInternalNormalizer((FileNormalizer)InputNormalizer.RUNTIME_CLASSPATH);
        }
        if (normalizer == CompileClasspathNormalizer.class) {
            return this.withInternalNormalizer((FileNormalizer)InputNormalizer.COMPILE_CLASSPATH);
        }
        DeprecationLogger.deprecateBehaviour((String)"Setting an input property's normalizer to a custom implementation of FileNormalizer").willBeRemovedInGradle9().undocumented();
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withInternalNormalizer(FileNormalizer normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    @Override
    public FileNormalizer getNormalizer() {
        return this.normalizer;
    }

    @Override
    public DirectorySensitivity getDirectorySensitivity() {
        return this.directorySensitivity;
    }

    public TaskInputFilePropertyBuilder ignoreEmptyDirectories() {
        this.directorySensitivity = DirectorySensitivity.IGNORE_DIRECTORIES;
        return this;
    }

    public TaskInputFilePropertyBuilder ignoreEmptyDirectories(boolean ignoreDirectories) {
        this.directorySensitivity = ignoreDirectories ? DirectorySensitivity.IGNORE_DIRECTORIES : DirectorySensitivity.DEFAULT;
        return this;
    }

    @Override
    public LineEndingSensitivity getLineEndingNormalization() {
        return this.lineEndingSensitivity;
    }

    public TaskInputFilePropertyBuilder normalizeLineEndings() {
        this.lineEndingSensitivity = LineEndingSensitivity.NORMALIZE_LINE_ENDINGS;
        return this;
    }

    public TaskInputFilePropertyBuilder normalizeLineEndings(boolean normalizeLineEndings) {
        this.lineEndingSensitivity = normalizeLineEndings ? LineEndingSensitivity.NORMALIZE_LINE_ENDINGS : LineEndingSensitivity.DEFAULT;
        return this;
    }

    public String toString() {
        return this.getPropertyName() + " (" + this.getNormalizer() + ")";
    }
}

