/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.dom.client.DOMImplStandard;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.ScriptElement;

class DOMImplStandardBase
extends DOMImplStandard {
    DOMImplStandardBase() {
    }

    private static native double getAbsoluteLeftUsingOffsets(Element var0);

    private static native double getAbsoluteTopUsingOffsets(Element var0);

    private static native ClientRect getBoundingClientRect(Element var0);

    @Override
    public native ButtonElement createButtonElement(Document var1, String var2);

    @Override
    public native NativeEvent createKeyCodeEvent(Document var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7);

    @Override
    @Deprecated
    public native NativeEvent createKeyEvent(Document var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10);

    @Override
    public native NativeEvent createKeyPressEvent(Document var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6);

    @Override
    public ScriptElement createScriptElement(Document doc, String source) {
        ScriptElement elem = (ScriptElement)this.createElement(doc, "script");
        elem.setInnerText(source);
        return elem;
    }

    @Override
    public native EventTarget eventGetCurrentTarget(NativeEvent var1);

    @Override
    public native int eventGetMouseWheelVelocityY(NativeEvent var1);

    @Override
    public int getAbsoluteLeft(Element elem) {
        ClientRect rect = DOMImplStandardBase.getBoundingClientRect(elem);
        double left = rect != null ? rect.getSubPixelLeft() + (double)elem.getOwnerDocument().getBody().getScrollLeft() : DOMImplStandardBase.getAbsoluteLeftUsingOffsets(elem);
        return DOMImplStandardBase.toInt32(left);
    }

    @Override
    public int getAbsoluteTop(Element elem) {
        ClientRect rect = DOMImplStandardBase.getBoundingClientRect(elem);
        double top = rect != null ? rect.getSubPixelTop() + (double)elem.getOwnerDocument().getBody().getScrollTop() : DOMImplStandardBase.getAbsoluteTopUsingOffsets(elem);
        return DOMImplStandardBase.toInt32(top);
    }

    @Override
    public native int getScrollLeft(Document var1);

    @Override
    public int getScrollLeft(Element elem) {
        if (!elem.hasTagName("body") && this.isRTL(elem)) {
            return super.getScrollLeft(elem) - (elem.getScrollWidth() - elem.getClientWidth());
        }
        return super.getScrollLeft(elem);
    }

    @Override
    public native int getScrollTop(Document var1);

    @Override
    public native int getTabIndex(Element var1);

    @Override
    public native void setScrollLeft(Document var1, int var2);

    @Override
    public void setScrollLeft(Element elem, int left) {
        if (!elem.hasTagName("body") && this.isRTL(elem)) {
            left += elem.getScrollWidth() - elem.getClientWidth();
        }
        super.setScrollLeft(elem, left);
    }

    @Override
    public native void setScrollTop(Document var1, int var2);

    protected native boolean isRTL(Element var1);

    private native NativeEvent createKeyEvent(Document var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    private static class ClientRect
    extends JavaScriptObject {
        protected ClientRect() {
        }

        public final int getLeft() {
            return DOMImpl.toInt32(this.getSubPixelLeft());
        }

        public final int getTop() {
            return DOMImpl.toInt32(this.getSubPixelTop());
        }

        private final native double getSubPixelLeft();

        private final native double getSubPixelTop();
    }
}

