/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.shared.impl.StringCase;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TagName;

@TagName(value={"h1", "h2", "h3", "h4", "h5", "h6"})
public class HeadingElement
extends Element {
    static final String[] TAGS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    public static final String TAG_H1 = "h1";
    public static final String TAG_H2 = "h2";
    public static final String TAG_H3 = "h3";
    public static final String TAG_H4 = "h4";
    public static final String TAG_H5 = "h5";
    public static final String TAG_H6 = "h6";

    public static HeadingElement as(Element elem) {
        if (HeadingElement.class.desiredAssertionStatus()) assert (HeadingElement.is(elem));
        return (HeadingElement)elem;
    }

    public static boolean is(JavaScriptObject o) {
        if (Element.is(o)) {
            return HeadingElement.is((Element)o);
        }
        return false;
    }

    public static boolean is(Node node) {
        if (Element.is(node)) {
            return HeadingElement.is((Element)node);
        }
        return false;
    }

    public static boolean is(Element elem) {
        if (elem == null) {
            return false;
        }
        String tag = StringCase.toLower(elem.getTagName());
        if (tag.length() != 2) {
            return false;
        }
        if (tag.charAt(0) != 'h') {
            return false;
        }
        int n = Integer.parseInt(tag.substring(1, 2));
        return n >= 1 && n <= 6;
    }

    protected HeadingElement() {
    }
}

