/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import java.util.ArrayList;
import java.util.Map;

public class SubstitutionReplacer
extends CssVisitor {
    private final ResourceContext context;
    private final JClassType dataResourceType;
    private final JClassType imageResourceType;
    private final TreeLogger logger;
    private final Map<String, CssDef> substitutions;

    public SubstitutionReplacer(TreeLogger logger, ResourceContext context, Map<String, CssDef> substitutions) {
        this.context = context;
        this.dataResourceType = context.getGeneratorContext().getTypeOracle().findType(DataResource.class.getCanonicalName());
        this.imageResourceType = context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getCanonicalName());
        this.logger = logger;
        this.substitutions = substitutions;
    }

    @Override
    public void endVisit(CssProperty x, Context ctx) {
        if (x.getValues() == null) {
            return;
        }
        x.setValue(this.substituteDefs(x.getValues()));
    }

    private CssProperty.ListValue substituteDefs(CssProperty.ListValue listValue) {
        ArrayList<CssProperty.Value> result = new ArrayList<CssProperty.Value>(listValue.getValues().size());
        for (CssProperty.Value val : listValue.getValues()) {
            if (val.isFunctionValue() != null) {
                CssProperty.FunctionValue fnVal = val.isFunctionValue();
                CssProperty.ListValue newVals = this.substituteDefs(fnVal.getValues());
                result.add(new CssProperty.FunctionValue(fnVal.getName(), newVals));
                continue;
            }
            CssProperty.IdentValue maybeIdent = val.isIdentValue();
            if (maybeIdent == null) {
                result.add(val);
                continue;
            }
            String identStr = maybeIdent.getIdent();
            CssDef def = this.substitutions.get(identStr);
            if (def == null) {
                result.add(val);
                continue;
            }
            if (def instanceof CssUrl) {
                assert (def.getValues().size() == 1);
                assert (def.getValues().get(0).isDotPathValue() != null);
                CssProperty.DotPathValue functionName = def.getValues().get(0).isDotPathValue();
                JType methodType = null;
                try {
                    methodType = ResourceGeneratorUtil.getMethodByPath(this.context.getClientBundleType(), functionName.getParts(), null).getReturnType();
                }
                catch (NotFoundException e) {
                    this.logger.log(TreeLogger.ERROR, e.getMessage());
                    throw new CssCompilerException("Cannot find data method");
                }
                if (!(methodType instanceof JClassType) || !this.dataResourceType.isAssignableFrom((JClassType)methodType) && !this.imageResourceType.isAssignableFrom((JClassType)methodType)) {
                    String message = "Invalid method type for url substitution: " + methodType + ". " + "Only DataResource and ImageResource are supported.";
                    this.logger.log(TreeLogger.ERROR, message);
                    throw new CssCompilerException(message);
                }
                StringBuilder expression = new StringBuilder();
                expression.append("\"url('\" + ");
                expression.append(this.context.getImplementationSimpleSourceName());
                expression.append(".this.");
                expression.append(functionName.getExpression());
                expression.append(".getSafeUri().asString()");
                expression.append(" + \"')\"");
                result.add(new CssProperty.ExpressionValue(expression.toString()));
                continue;
            }
            for (CssProperty.Value defValue : def.getValues()) {
                result.add(defValue);
            }
        }
        return new CssProperty.ListValue(result);
    }
}

