/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.view.client.TreeViewModel;

public abstract class AbstractCellTree
extends Composite
implements HasOpenHandlers<TreeNode>,
HasCloseHandlers<TreeNode>,
HasKeyboardSelectionPolicy {
    private HasKeyboardSelectionPolicy.KeyboardSelectionPolicy keyboardSelectionPolicy = HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED;
    private final TreeViewModel viewModel;

    public AbstractCellTree(TreeViewModel viewModel) {
        this.viewModel = viewModel;
    }

    @Override
    public HandlerRegistration addCloseHandler(CloseHandler<TreeNode> handler) {
        return this.addHandler(handler, CloseEvent.getType());
    }

    @Override
    public HandlerRegistration addOpenHandler(OpenHandler<TreeNode> handler) {
        return this.addHandler(handler, OpenEvent.getType());
    }

    @Override
    public HasKeyboardSelectionPolicy.KeyboardSelectionPolicy getKeyboardSelectionPolicy() {
        return this.keyboardSelectionPolicy;
    }

    public abstract TreeNode getRootTreeNode();

    public TreeViewModel getTreeViewModel() {
        return this.viewModel;
    }

    @Override
    public void setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("KeyboardSelectionPolicy cannot be null");
        }
        this.keyboardSelectionPolicy = policy;
    }

    protected <T> TreeViewModel.NodeInfo<?> getNodeInfo(T value) {
        return this.viewModel.getNodeInfo(value);
    }

    protected boolean isKeyboardSelectionDisabled() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy;
    }

    protected boolean isLeaf(Object value) {
        return this.viewModel.isLeaf(value);
    }
}

