/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.touch.client.TouchScroller;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasScrolling;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollImpl;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesScrollEvents;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class ScrollPanel
extends SimplePanel
implements SourcesScrollEvents,
RequiresResize,
ProvidesResize,
HasScrolling {
    private final com.google.gwt.dom.client.Element containerElem;
    private final com.google.gwt.dom.client.Element scrollableElem;
    private TouchScroller touchScroller;

    public ScrollPanel() {
        this.scrollableElem = this.getElement();
        this.containerElem = Document.get().createDivElement();
        this.scrollableElem.appendChild(this.containerElem);
        this.initialize();
    }

    public ScrollPanel(Widget child) {
        this();
        this.setWidget(child);
    }

    protected ScrollPanel(com.google.gwt.dom.client.Element root, com.google.gwt.dom.client.Element scrollable, com.google.gwt.dom.client.Element container) {
        super(root);
        this.scrollableElem = scrollable;
        this.containerElem = container;
        this.initialize();
    }

    @Override
    public HandlerRegistration addScrollHandler(ScrollHandler handler) {
        Event.sinkEvents(this.getScrollableElement(), 16384);
        return this.addHandler(handler, ScrollEvent.getType());
    }

    @Override
    @Deprecated
    public void addScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.add(this, listener);
    }

    public void ensureVisible(UIObject item) {
        Element scroll = this.getScrollableElement();
        Element element = item.getElement();
        this.ensureVisibleImpl(scroll, element);
    }

    @Override
    public int getHorizontalScrollPosition() {
        return this.getScrollableElement().getScrollLeft();
    }

    @Override
    public int getMaximumHorizontalScrollPosition() {
        return ScrollImpl.get().getMaximumHorizontalScrollPosition(this.getScrollableElement());
    }

    @Override
    public int getMaximumVerticalScrollPosition() {
        return this.getScrollableElement().getScrollHeight() - this.getScrollableElement().getClientHeight();
    }

    @Override
    public int getMinimumHorizontalScrollPosition() {
        return ScrollImpl.get().getMinimumHorizontalScrollPosition(this.getScrollableElement());
    }

    @Override
    public int getMinimumVerticalScrollPosition() {
        return 0;
    }

    @Deprecated
    public int getScrollPosition() {
        return this.getScrollableElement().getScrollTop();
    }

    @Override
    public int getVerticalScrollPosition() {
        return this.getScrollPosition();
    }

    public boolean isTouchScrollingDisabled() {
        return this.touchScroller == null;
    }

    @Override
    public void onResize() {
        Widget child = this.getWidget();
        if (child != null && child instanceof RequiresResize) {
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    @Override
    @Deprecated
    public void removeScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.remove(this, listener);
    }

    public void scrollToBottom() {
        this.setVerticalScrollPosition(this.getMaximumVerticalScrollPosition());
    }

    public void scrollToLeft() {
        this.setHorizontalScrollPosition(this.getMinimumHorizontalScrollPosition());
    }

    public void scrollToRight() {
        this.setHorizontalScrollPosition(this.getMaximumHorizontalScrollPosition());
    }

    public void scrollToTop() {
        this.setVerticalScrollPosition(this.getMinimumVerticalScrollPosition());
    }

    public void setAlwaysShowScrollBars(boolean alwaysShow) {
        this.getScrollableElement().getStyle().setOverflow(alwaysShow ? Style.Overflow.SCROLL : Style.Overflow.AUTO);
    }

    @Override
    public void setHeight(String height) {
        super.setHeight(height);
    }

    @Override
    public void setHorizontalScrollPosition(int position) {
        this.getScrollableElement().setScrollLeft(position);
    }

    @Deprecated
    public void setScrollPosition(int position) {
        this.getScrollableElement().setScrollTop(position);
    }

    @Override
    public void setSize(String width, String height) {
        super.setSize(width, height);
    }

    public boolean setTouchScrollingDisabled(boolean isDisabled) {
        if (isDisabled == this.isTouchScrollingDisabled()) {
            return isDisabled;
        }
        if (isDisabled) {
            this.touchScroller.setTargetWidget(null);
            this.touchScroller = null;
        } else {
            this.touchScroller = TouchScroller.createIfSupported(this);
        }
        return this.isTouchScrollingDisabled();
    }

    @Override
    public void setVerticalScrollPosition(int position) {
        this.setScrollPosition(position);
    }

    @Override
    public void setWidth(String width) {
        super.setWidth(width);
    }

    @Override
    protected Element getContainerElement() {
        return DOM.asOld(this.containerElem);
    }

    protected Element getScrollableElement() {
        return DOM.asOld(this.scrollableElem);
    }

    @Override
    protected void onAttach() {
        super.onAttach();
        Event.setEventListener(this.getScrollableElement(), this);
    }

    @Override
    protected void onDetach() {
        Event.setEventListener(this.getScrollableElement(), null);
        super.onDetach();
    }

    private native void ensureVisibleImpl(com.google.gwt.dom.client.Element var1, com.google.gwt.dom.client.Element var2);

    private void initialize() {
        this.setAlwaysShowScrollBars(false);
        this.scrollableElem.getStyle().setPosition(Style.Position.RELATIVE);
        this.containerElem.getStyle().setPosition(Style.Position.RELATIVE);
        this.scrollableElem.getStyle().setProperty("zoom", "1");
        this.containerElem.getStyle().setProperty("zoom", "1");
        this.setTouchScrollingDisabled(false);
        ScrollImpl.get().initialize(this.scrollableElem, this.containerElem);
    }
}

