/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.config.ApplicationConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u000fJ\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/config/HoconApplicationConfig;", "Lio/ktor/server/config/ApplicationConfig;", "Lcom/typesafe/config/Config;", "config", "<init>", "(Lcom/typesafe/config/Config;)V", "", "path", "Lio/ktor/server/config/ApplicationConfigValue;", "property", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfigValue;", "propertyOrNull", "", "configList", "(Ljava/lang/String;)Ljava/util/List;", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "", "keys", "()Ljava/util/Set;", "", "", "toMap", "()Ljava/util/Map;", "Lcom/typesafe/config/Config;", "HoconApplicationConfigValue", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nHoconApplicationConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1557#2:95\n1628#2,3:96\n1557#2:99\n1628#2,3:100\n*S KotlinDebug\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n*L\n59#1:95\n59#1:96,3\n65#1:99\n65#1:100,3\n*E\n"})
public class HoconApplicationConfig
implements ApplicationConfig {
    @NotNull
    private final Config config;

    public HoconApplicationConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Override
    @NotNull
    public ApplicationConfigValue property(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.config.hasPath(path)) {
            throw new ApplicationConfigurationException("Property " + path + " not found.");
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    @Override
    @Nullable
    public ApplicationConfigValue propertyOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.config.hasPath(path)) {
            return null;
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ApplicationConfig> configList(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<? extends Config> list = this.config.getConfigList(path);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getConfigList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Config config = (Config)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new HoconApplicationConfig((Config)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ApplicationConfig config(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Config config = this.config.getConfig(path);
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"getConfig(...)");
        return new HoconApplicationConfig(config);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> keys() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<String, ConfigValue>> set = this.config.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"entrySet(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Object object = this.config.root().unwrapped();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unwrapped(...)");
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/config/HoconApplicationConfig$HoconApplicationConfigValue;", "Lio/ktor/server/config/ApplicationConfigValue;", "Lcom/typesafe/config/Config;", "config", "", "path", "<init>", "(Lcom/typesafe/config/Config;Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "", "getList", "()Ljava/util/List;", "Lcom/typesafe/config/Config;", "getConfig", "()Lcom/typesafe/config/Config;", "Ljava/lang/String;", "getPath", "ktor-server-core"})
    private static final class HoconApplicationConfigValue
    implements ApplicationConfigValue {
        @NotNull
        private final Config config;
        @NotNull
        private final String path;

        public HoconApplicationConfigValue(@NotNull Config config, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.config = config;
            this.path = path;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getString() {
            String string = this.config.getString(this.path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }

        @Override
        @NotNull
        public List<String> getList() {
            List<String> list = this.config.getStringList(this.path);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStringList(...)");
            return list;
        }
    }
}

