/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubClassingBag<T> {
    @NotNull
    private final ClassificationBag<Class<?>, T> items;
    @NotNull
    private final HashMap<Class<?>, BitSet> subClassMap;

    public SubClassingBag(@NotNull ClassificationBag<Class<?>, T> items, HashMap<Class<?>, @NotNull List<Class<?>>> subClassMap) {
        this.items = items;
        this.subClassMap = new HashMap();
        for (Class<?> clazz : subClassMap.keySet()) {
            List<Class<?>> classList = subClassMap.get(clazz);
            BitSet bitSet = this.items.categoriesBitSet((Collection<Class<?>>)classList);
            if (bitSet.isEmpty()) continue;
            this.subClassMap.put(clazz, bitSet);
        }
    }

    @NotNull
    public OrderedSet<T> getItems() {
        return this.items.getItems();
    }

    public boolean contains(@Nullable T item) {
        return this.items.contains(item);
    }

    public boolean containsType(@Nullable Class<?> type) {
        return this.items.containsCategory(type);
    }

    public BitSet getTypeSet(@Nullable Class<?> category) {
        return this.subClassMap.get(category);
    }

    public int getTypeCount(@Nullable Class<?> category) {
        BitSet bitSet = this.subClassMap.get(category);
        return bitSet == null ? 0 : bitSet.cardinality();
    }

    @NotNull
    public final <X> ReversibleIterable<X> itemsOfType(@NotNull Class<X> xClass, Class<?> ... categories) {
        return this.items.getCategoryItems(xClass, this.typeBitSet(xClass, categories));
    }

    @NotNull
    public final <X> ReversibleIterable<X> itemsOfType(@NotNull Class<X> xClass, @NotNull Collection<Class<?>> categories) {
        return this.items.getCategoryItems(xClass, this.typeBitSet(xClass, categories));
    }

    @NotNull
    public final <X> ReversibleIterable<X> reversedItemsOfType(@NotNull Class<X> xClass, Class<?> ... categories) {
        return this.items.getCategoryItemsReversed(xClass, this.typeBitSet(xClass, categories));
    }

    @NotNull
    public final <X> ReversibleIterable<X> reversedItemsOfType(@NotNull Class<X> xClass, @NotNull Collection<Class<?>> categories) {
        return this.items.getCategoryItemsReversed(xClass, this.typeBitSet(xClass, categories));
    }

    @NotNull
    public final BitSet typeBitSet(@NotNull Class<?> xClass, Class<?> ... categories) {
        BitSet bitSet = new BitSet();
        for (Class<?> category : categories) {
            if (!xClass.isAssignableFrom(category) || !this.subClassMap.containsKey(category)) continue;
            bitSet.or(this.subClassMap.get(category));
        }
        return bitSet;
    }

    @NotNull
    public final BitSet typeBitSet(@NotNull Class<?> xClass, @NotNull Collection<Class<?>> categories) {
        BitSet bitSet = new BitSet();
        for (Class<?> category : categories) {
            if (!xClass.isAssignableFrom(category) || !this.subClassMap.containsKey(category)) continue;
            bitSet.or(this.subClassMap.get(category));
        }
        return bitSet;
    }
}

