/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.BaseJavaJspElementType;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            ForStatementFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return;
        }
        ASTNode lParenth = BasicJavaAstTreeUtil.getLParenth(astNode);
        ASTNode rParenth = BasicJavaAstTreeUtil.getRParenth(astNode);
        if (lParenth == null || rParenth == null) {
            TextRange textRange = astNode.getTextRange();
            editor.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)"for () {\n}");
            processor.registerUnresolvedError(textRange.getStartOffset() + "for (".length());
            return;
        }
        ASTNode initialization = BasicJavaAstTreeUtil.getForInitialization(astNode);
        if (initialization == null) {
            processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
            return;
        }
        ASTNode condition = BasicJavaAstTreeUtil.getForCondition(astNode);
        if (condition == null) {
            boolean endlessLoop;
            boolean bl = endlessLoop = BasicJavaAstTreeUtil.is(initialization, BasicJavaElementType.BASIC_EMPTY_STATEMENT) && BasicJavaAstTreeUtil.getForUpdate(astNode) == null;
            if (!endlessLoop) {
                ForStatementFixer.registerErrorOffset(editor, processor, initialization, astNode);
            }
            return;
        }
        if (BasicJavaAstTreeUtil.getForUpdate(astNode) == null) {
            ForStatementFixer.registerErrorOffset(editor, processor, condition, astNode);
        }
    }

    private static void registerErrorOffset(@NotNull Editor editor, @NotNull AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode lastValidForPart, @NotNull ASTNode forStatement) {
        if (editor == null) {
            ForStatementFixer.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ForStatementFixer.$$$reportNull$$$0(2);
        }
        if (lastValidForPart == null) {
            ForStatementFixer.$$$reportNull$$$0(3);
        }
        if (forStatement == null) {
            ForStatementFixer.$$$reportNull$$$0(4);
        }
        Project project = editor.getProject();
        int offset = lastValidForPart.getTextRange().getEndOffset();
        if (project != null && CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_COMMA) {
            if (editor.getDocument().getCharsSequence().charAt(lastValidForPart.getTextRange().getEndOffset() - 1) != ';') {
                ++offset;
            }
            for (ASTNode element = lastValidForPart.getTreeNext(); element != null && element != BasicJavaAstTreeUtil.getRParenth(forStatement) && element.getTreeParent() == forStatement; element = element.getTreeNext()) {
                if (!ForStatementFixer.isWhiteSpaceIncludingJsp(element) || element.getTextLength() <= 0) continue;
                ++offset;
                break;
            }
        }
        processor.registerUnresolvedError(offset);
    }

    private static boolean isWhiteSpaceIncludingJsp(@NotNull ASTNode node) {
        if (node == null) {
            ForStatementFixer.$$$reportNull$$$0(5);
        }
        return BaseJavaJspElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastValidForPart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerErrorOffset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhiteSpaceIncludingJsp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

