/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.gitlab.ultimate.features.expressionLang;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.GitLabCiExpressionElementType;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.GitLabCiExpressionTokenType;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiBinaryAndExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiBinaryOrExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiCompareExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiEnvironmentVariableExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiEnvironmentVariableImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiParenthesizedExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiPrimitiveExpressionImpl;
import com.intellij.vcs.gitlab.ultimate.features.expressionLang.impl.GitLabCiRegexpMatchingExpressionImpl;

public interface GitLabCiExpressionElementTypes {
    public static final IElementType BINARY_AND_EXPRESSION = new GitLabCiExpressionElementType("BINARY_AND_EXPRESSION");
    public static final IElementType BINARY_OR_EXPRESSION = new GitLabCiExpressionElementType("BINARY_OR_EXPRESSION");
    public static final IElementType COMPARE_EXPRESSION = new GitLabCiExpressionElementType("COMPARE_EXPRESSION");
    public static final IElementType ENVIRONMENT_VARIABLE = new GitLabCiExpressionElementType("ENVIRONMENT_VARIABLE");
    public static final IElementType ENVIRONMENT_VARIABLE_EXPRESSION = new GitLabCiExpressionElementType("ENVIRONMENT_VARIABLE_EXPRESSION");
    public static final IElementType EXPRESSION = new GitLabCiExpressionElementType("EXPRESSION");
    public static final IElementType PARENTHESIZED_EXPRESSION = new GitLabCiExpressionElementType("PARENTHESIZED_EXPRESSION");
    public static final IElementType PRIMITIVE_EXPRESSION = new GitLabCiExpressionElementType("PRIMITIVE_EXPRESSION");
    public static final IElementType REGEXP_MATCHING_EXPRESSION = new GitLabCiExpressionElementType("REGEXP_MATCHING_EXPRESSION");
    public static final IElementType BINARY_AND = new GitLabCiExpressionTokenType("&&");
    public static final IElementType BINARY_EQUAL = new GitLabCiExpressionTokenType("==");
    public static final IElementType BINARY_NOT_EQUAL = new GitLabCiExpressionTokenType("!=");
    public static final IElementType BINARY_OR = new GitLabCiExpressionTokenType("||");
    public static final IElementType BINARY_REGEXP_MATHES_FOUND = new GitLabCiExpressionTokenType("=~");
    public static final IElementType BINARY_REGEXP_MATHES_NOT_FOUND = new GitLabCiExpressionTokenType("!~");
    public static final IElementType ENVIRONMENT_VARIABLE_PREFIX = new GitLabCiExpressionTokenType("$");
    public static final IElementType IDENTIFIER = new GitLabCiExpressionTokenType("IDENTIFIER");
    public static final IElementType LEFT_GROUPING_PARENTHESIS = new GitLabCiExpressionTokenType("(");
    public static final IElementType NULL = new GitLabCiExpressionTokenType("null");
    public static final IElementType REGEXP = new GitLabCiExpressionTokenType("REGEXP");
    public static final IElementType RIGHT_GROUPING_PARENTHESIS = new GitLabCiExpressionTokenType(")");
    public static final IElementType STRING = new GitLabCiExpressionTokenType("STRING");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BINARY_AND_EXPRESSION) {
                return new GitLabCiBinaryAndExpressionImpl(node);
            }
            if (type == BINARY_OR_EXPRESSION) {
                return new GitLabCiBinaryOrExpressionImpl(node);
            }
            if (type == COMPARE_EXPRESSION) {
                return new GitLabCiCompareExpressionImpl(node);
            }
            if (type == ENVIRONMENT_VARIABLE) {
                return new GitLabCiEnvironmentVariableImpl(node);
            }
            if (type == ENVIRONMENT_VARIABLE_EXPRESSION) {
                return new GitLabCiEnvironmentVariableExpressionImpl(node);
            }
            if (type == PARENTHESIZED_EXPRESSION) {
                return new GitLabCiParenthesizedExpressionImpl(node);
            }
            if (type == PRIMITIVE_EXPRESSION) {
                return new GitLabCiPrimitiveExpressionImpl(node);
            }
            if (type == REGEXP_MATCHING_EXPRESSION) {
                return new GitLabCiRegexpMatchingExpressionImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

