/*
 * Decompiled with CFR 0.152.
 */
package qdbm;

import java.util.Random;
import qdbm.Util;
import qdbm.Villa;
import qdbm.VillaException;

class VillaTester
extends Thread {
    private static final int LOOPNUM = 10000;
    private static final int THREADNUM = 10;
    private static final Random RND = new Random();
    private Villa myvilla;
    private int myid;
    private boolean myprinter;
    private VillaException myve;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("usege: java qdbm.VillaTester name");
            return;
        }
        if (!VillaTester.dowrite(stringArray[0], false)) {
            System.exit(1);
        }
        if (!VillaTester.doread(stringArray[0])) {
            System.exit(1);
        }
        if (!VillaTester.domulti(stringArray[0], false)) {
            System.exit(1);
        }
        if (!VillaTester.dowrite(stringArray[0], true)) {
            System.exit(1);
        }
        if (!VillaTester.doread(stringArray[0])) {
            System.exit(1);
        }
        if (!VillaTester.domulti(stringArray[0], true)) {
            System.exit(1);
        }
        System.out.println("all ok");
        System.out.println("");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dowrite(String string, boolean bl) {
        System.out.println("<Writing Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Villa villa = null;
        boolean bl2 = false;
        try {
            System.out.print("Creating ... ");
            int n = 14;
            if (bl) {
                n |= 0x40;
            }
            villa = new Villa(string, n, 0);
            System.out.println("ok");
            System.out.println("Writing");
            for (int i = 1; i <= 10000; ++i) {
                byte[] byArray = Util.numstr(i, 8, '0').getBytes();
                villa.put(byArray, byArray, 0);
                if (i % 40 != 0) continue;
                System.out.print('.');
                System.out.flush();
                if (i != 10000 && i % 1000 != 0) continue;
                System.out.println(" (" + new String(byArray) + ")");
                System.out.flush();
            }
            System.out.println("ok");
        }
        catch (VillaException villaException) {
            bl2 = true;
            System.err.println(villaException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (villa != null) {
                    villa.close();
                }
                System.out.println("ok");
            }
            catch (VillaException villaException) {}
        }
        System.out.println("");
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doread(String string) {
        System.out.println("<Reading Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Villa villa = null;
        boolean bl = false;
        try {
            System.out.print("Opening ... ");
            villa = new Villa(string);
            System.out.println("ok");
            System.out.println("Reading");
            for (int i = 1; i <= 10000; ++i) {
                byte[] byArray = Util.numstr(i, 8, '0').getBytes();
                villa.get(byArray);
                if (i % 40 != 0) continue;
                System.out.print('.');
                System.out.flush();
                if (i != 10000 && i % 1000 != 0) continue;
                System.out.println(" (" + new String(byArray) + ")");
                System.out.flush();
            }
            System.out.println("ok");
        }
        catch (VillaException villaException) {
            bl = true;
            System.err.println(villaException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (villa != null) {
                    villa.close();
                }
                System.out.println("ok");
            }
            catch (VillaException villaException) {}
        }
        System.out.println("");
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean domulti(String string, boolean bl) {
        System.out.println("<Multi-thread Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Villa villa = null;
        boolean bl2 = false;
        try {
            int n;
            System.out.print("Opening ... ");
            int n2 = 14;
            if (bl) {
                n2 |= 0x40;
            }
            villa = new Villa(string, n2, 0);
            System.out.println("ok");
            VillaTester[] villaTesterArray = new VillaTester[10];
            System.out.println("Writing");
            for (n = 0; n < villaTesterArray.length; ++n) {
                villaTesterArray[n] = new VillaTester(villa, n, n == villaTesterArray.length / 2);
                villaTesterArray[n].start();
            }
            for (n = 0; n < villaTesterArray.length; ++n) {
                try {
                    villaTesterArray[n].join();
                    if (villaTesterArray[n].myve == null) continue;
                    bl2 = true;
                    System.err.println(villaTesterArray[n].myve);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    --n;
                }
            }
            if (!bl2) {
                System.out.println("ok");
            }
            System.out.flush();
            System.out.print("Validation checking ... ");
            for (n = 1; n <= 10000; ++n) {
                int n3;
                byte[] byArray = Util.numstr(n, 8, '0').getBytes();
                byte[] byArray2 = villa.get(byArray);
                if (byArray2.length != 1 || villa.vsiz(byArray) != 1) {
                    bl2 = true;
                    System.err.println("size error: " + byArray2.length);
                }
                if ((n3 = villa.vnum(byArray)) == 10) continue;
                bl2 = true;
                System.err.println("vnum error: " + n3);
            }
            if (!bl2) {
                System.out.println("ok");
            }
        }
        catch (VillaException villaException) {
            bl2 = true;
            System.err.println(villaException);
        }
        finally {
            try {
                System.out.print("Closing ... ");
                if (villa != null) {
                    villa.close();
                }
                System.out.println("ok");
            }
            catch (VillaException villaException) {}
        }
        System.out.println("");
        return !bl2;
    }

    private VillaTester(Villa villa, int n, boolean bl) {
        this.myvilla = villa;
        this.myid = n;
        this.myprinter = bl;
        this.myve = null;
    }

    @Override
    public void run() {
        for (int i = 1; i <= 10000; ++i) {
            byte[] byArray = Util.numstr(i, 8, '0').getBytes();
            boolean bl = false;
            try {
                if (RND.nextInt(1429) == 0) {
                    this.myvilla.tranbegin();
                    bl = true;
                }
                if (RND.nextInt(500) == 0) {
                    VillaTester.yield();
                }
                this.myvilla.put(byArray, (this.myid % 2 == 0 ? "=" : "*").getBytes(), RND.nextInt(3) == 0 ? 4 : 3);
            }
            catch (VillaException villaException) {
                try {
                    if (bl) {
                        this.myvilla.tranabort();
                    }
                }
                catch (VillaException villaException2) {
                    // empty catch block
                }
                this.myve = villaException;
                return;
            }
            try {
                if (bl) {
                    this.myvilla.trancommit();
                }
            }
            catch (VillaException villaException) {
                this.myve = villaException;
                return;
            }
            if (!this.myprinter || i % 40 != 0) continue;
            System.out.print('.');
            System.out.flush();
            if (i != 10000 && i % 1000 != 0) continue;
            System.out.println(" (" + new String(byArray) + ")");
            System.out.flush();
            System.gc();
        }
    }
}

