/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;

public class MinLineNumberVisitor {
    public static int visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 271: {
                return MinLineNumberVisitor.visit(((ArrayLoadInstruction)instruction).arrayref);
            }
            case 83: 
            case 272: {
                return MinLineNumberVisitor.visit(((ArrayStoreInstruction)instruction).arrayref);
            }
            case 265: {
                return MinLineNumberVisitor.visit(((AssignmentInstruction)instruction).value1);
            }
            case 267: {
                return MinLineNumberVisitor.visit(((BinaryOperatorInstruction)instruction).value1);
            }
            case 277: {
                IncInstruction ii = (IncInstruction)instruction;
                switch (ii.count) {
                    case -1: 
                    case 1: {
                        return instruction.lineNumber;
                    }
                }
                return MinLineNumberVisitor.visit(ii.value);
            }
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                switch (ii.count) {
                    case -1: 
                    case 1: {
                        return MinLineNumberVisitor.visit(ii.value);
                    }
                }
                return instruction.lineNumber;
            }
            case 193: {
                return MinLineNumberVisitor.visit(((InstanceOf)instruction).objectref);
            }
            case 182: 
            case 183: 
            case 185: {
                return MinLineNumberVisitor.visit(((InvokeNoStaticInstruction)instruction).objectref);
            }
            case 87: {
                return MinLineNumberVisitor.visit(((Pop)instruction).objectref);
            }
            case 181: {
                return MinLineNumberVisitor.visit(((PutField)instruction).objectref);
            }
            case 281: {
                return MinLineNumberVisitor.visit(((TernaryOperator)instruction).test);
            }
        }
        return instruction.lineNumber;
    }
}

