/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.proxy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.server.AsyncHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.SPDYServerConnector;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.BytesDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.proxy.ProxyEngineSelector;

public class ProxyHTTPSPDYAsyncConnection
extends AsyncHttpConnection {
    private final Headers headers = new Headers();
    private final short version;
    private final ProxyEngineSelector proxyEngineSelector;
    private final HttpGenerator generator;
    private final ISession session;
    private HTTPStream stream;
    private Buffer content;

    public ProxyHTTPSPDYAsyncConnection(SPDYServerConnector connector, EndPoint endPoint, short version, ProxyEngineSelector proxyEngineSelector) {
        super((Connector)connector, endPoint, connector.getServer());
        this.version = version;
        this.proxyEngineSelector = proxyEngineSelector;
        this.generator = (HttpGenerator)this._generator;
        this.session = new HTTPSession(version, connector);
        this.session.setAttribute("org.eclipse.jetty.spdy.remoteAddress", (Object)endPoint.getRemoteAddr());
    }

    public AsyncEndPoint getEndPoint() {
        return (AsyncEndPoint)super.getEndPoint();
    }

    protected void startRequest(Buffer method, Buffer uri, Buffer httpVersion) throws IOException {
        SPDYServerConnector connector = (SPDYServerConnector)this.getConnector();
        String scheme = connector.getSslContextFactory() != null ? "https" : "http";
        this.headers.put(HTTPSPDYHeader.SCHEME.name(this.version), scheme);
        this.headers.put(HTTPSPDYHeader.METHOD.name(this.version), method.toString("UTF-8"));
        this.headers.put(HTTPSPDYHeader.URI.name(this.version), uri.toString("UTF-8"));
        this.headers.put(HTTPSPDYHeader.VERSION.name(this.version), httpVersion.toString("UTF-8"));
    }

    protected void parsedHeader(Buffer name, Buffer value) throws IOException {
        String headerName = name.toString("UTF-8").toLowerCase(Locale.ENGLISH);
        String headerValue = value.toString("UTF-8");
        switch (headerName) {
            case "host": {
                this.headers.put(HTTPSPDYHeader.HOST.name(this.version), headerValue);
                break;
            }
            default: {
                this.headers.put(headerName, headerValue);
            }
        }
    }

    protected void headerComplete() throws IOException {
    }

    protected void content(Buffer buffer) throws IOException {
        if (this.content == null) {
            this.stream = this.syn(false);
            this.content = buffer;
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(buffer, false));
        }
    }

    public void messageComplete(long contentLength) throws IOException {
        if (this.stream == null) {
            assert (this.content == null);
            if (this.headers.isEmpty()) {
                this.proxyEngineSelector.onGoAway((Session)this.session, new GoAwayInfo(0, SessionStatus.OK));
            } else {
                this.syn(true);
            }
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(this.content, true));
        }
        this.headers.clear();
        this.stream = null;
        this.content = null;
    }

    private HTTPStream syn(boolean close) {
        HTTPStream stream = new HTTPStream(1, 0, this.session, null);
        StreamFrameListener streamFrameListener = this.proxyEngineSelector.onSyn((Stream)stream, new SynInfo(this.headers, close));
        stream.setStreamFrameListener(streamFrameListener);
        return stream;
    }

    private DataInfo toDataInfo(Buffer buffer, boolean close) {
        if (buffer instanceof ByteArrayBuffer) {
            return new BytesDataInfo(buffer.array(), buffer.getIndex(), buffer.length(), close);
        }
        if (buffer instanceof NIOBuffer) {
            ByteBuffer byteBuffer = ((NIOBuffer)buffer).getByteBuffer();
            byteBuffer.limit(buffer.putIndex());
            byteBuffer.position(buffer.getIndex());
            return new ByteBufferDataInfo(byteBuffer, close);
        }
        return new BytesDataInfo(buffer.asArray(), close);
    }

    private class HTTPPushStream
    extends StandardStream {
        private HTTPPushStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream);
        }

        public void headers(HeadersInfo headersInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            handler.completed(null);
        }

        public void data(DataInfo dataInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            handler.completed(null);
        }
    }

    private class HTTPStream
    extends StandardStream {
        private final Pattern statusRegexp;

        private HTTPStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream);
            this.statusRegexp = Pattern.compile("(\\d{3})\\s*(.*)");
        }

        public void syn(SynInfo synInfo, long timeout, TimeUnit unit, Handler<Stream> handler) {
            handler.completed((Object)new HTTPPushStream(2, this.getPriority(), this.getSession(), (IStream)this));
        }

        public void headers(HeadersInfo headersInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }

        public void reply(ReplyInfo replyInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            try {
                Headers headers = new Headers(replyInfo.getHeaders(), false);
                headers.remove(HTTPSPDYHeader.SCHEME.name(ProxyHTTPSPDYAsyncConnection.this.version));
                String status = headers.remove(HTTPSPDYHeader.STATUS.name(ProxyHTTPSPDYAsyncConnection.this.version)).value();
                Matcher matcher = this.statusRegexp.matcher(status);
                matcher.matches();
                int code = Integer.parseInt(matcher.group(1));
                String reason = matcher.group(2);
                ProxyHTTPSPDYAsyncConnection.this.generator.setResponse(code, reason);
                String httpVersion = headers.remove(HTTPSPDYHeader.VERSION.name(ProxyHTTPSPDYAsyncConnection.this.version)).value();
                ProxyHTTPSPDYAsyncConnection.this.generator.setVersion(Integer.parseInt(httpVersion.replaceAll("\\D", "")));
                Headers.Header host = headers.remove(HTTPSPDYHeader.HOST.name(ProxyHTTPSPDYAsyncConnection.this.version));
                if (host != null) {
                    headers.put("host", host.value());
                }
                HttpFields fields = new HttpFields();
                for (Headers.Header header : headers) {
                    String name = this.camelize(header.name());
                    fields.put(name, header.value());
                }
                ProxyHTTPSPDYAsyncConnection.this.generator.completeHeader(fields, replyInfo.isClose());
                if (replyInfo.isClose()) {
                    this.complete();
                }
                handler.completed(null);
            }
            catch (IOException x) {
                handler.failed(null, (Throwable)x);
            }
        }

        private String camelize(String name) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                int j = i + 1;
                if (c != '-' || j >= chars.length) continue;
                chars[j] = Character.toUpperCase(chars[j]);
            }
            return new String(chars);
        }

        public void data(DataInfo dataInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            try {
                ByteBuffer byteBuffer = dataInfo.asByteBuffer(false);
                DirectNIOBuffer buffer = byteBuffer.isDirect() ? new DirectNIOBuffer(byteBuffer, false) : new IndirectNIOBuffer(byteBuffer, false);
                ProxyHTTPSPDYAsyncConnection.this.generator.addContent((Buffer)buffer, dataInfo.isClose());
                ProxyHTTPSPDYAsyncConnection.this.generator.flush(unit.toMillis(timeout));
                if (dataInfo.isClose()) {
                    this.complete();
                }
                handler.completed(null);
            }
            catch (IOException x) {
                handler.failed(null, (Throwable)x);
            }
        }

        private void complete() throws IOException {
            ProxyHTTPSPDYAsyncConnection.this.generator.complete();
            ProxyHTTPSPDYAsyncConnection.this.getEndPoint().asyncDispatch();
        }
    }

    private class HTTPSession
    extends StandardSession {
        private HTTPSession(short version, SPDYServerConnector connector) {
            super(version, connector.getByteBufferPool(), connector.getExecutor(), connector.getScheduler(), null, null, 1, (SessionFrameListener)ProxyHTTPSPDYAsyncConnection.this.proxyEngineSelector, null, null);
        }

        public void rst(RstInfo rstInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
            this.goAway(timeout, unit, handler);
        }

        public void goAway(long timeout, TimeUnit unit, Handler<Void> handler) {
            try {
                ProxyHTTPSPDYAsyncConnection.this.getEndPoint().close();
                handler.completed(null);
            }
            catch (IOException x) {
                handler.failed(null, (Throwable)x);
            }
        }
    }
}

