/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.xmpp.BaseBrewery;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.event.AsyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.health.HealthStatusPacketExt;
import org.jitsi.xmpp.extensions.jibri.JibriBusyStatusPacketExt;
import org.jitsi.xmpp.extensions.jibri.JibriStatusPacketExt;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003,-.B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0017J\u0010\u0010&\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0017H\u0014J\u0018\u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0002H\u0014J\u000e\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014J\b\u0010+\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lorg/jitsi/jicofo/jibri/JibriDetector;", "Lorg/jitsi/jicofo/xmpp/BaseBrewery;", "Lorg/jitsi/xmpp/extensions/jibri/JibriStatusPacketExt;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "breweryJid", "Lorg/jxmpp/jid/EntityBareJid;", "isSip", "", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jxmpp/jid/EntityBareJid;ZLjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "eventEmitter", "Lorg/jitsi/utils/event/AsyncEventEmitter;", "Lorg/jitsi/jicofo/jibri/JibriDetector$EventHandler;", "jibriInstances", "", "Lorg/jxmpp/jid/Jid;", "Lorg/jitsi/jicofo/jibri/JibriDetector$JibriInstance;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "getXmppConnection", "()Lorg/jivesoftware/smack/AbstractXMPPConnection;", "addHandler", "", "eventHandler", "instanceFailed", "jid", "notifyInstanceOffline", "onInstanceStatusChanged", "Lorg/jxmpp/jid/EntityFullJid;", "presenceExt", "removeHandler", "selectJibri", "Companion", "EventHandler", "JibriInstance", "jicofo"})
@SourceDebugExtension(value={"SMAP\nJibriDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JibriDetector.kt\norg/jitsi/jicofo/jibri/JibriDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n774#3:196\n865#3,2:197\n2341#3,14:199\n1863#3,2:213\n*S KotlinDebug\n*F\n+ 1 JibriDetector.kt\norg/jitsi/jicofo/jibri/JibriDetector\n*L\n71#1:196\n71#1:197,2\n73#1:199,14\n136#1:213,2\n*E\n"})
public final class JibriDetector
extends BaseBrewery<JibriStatusPacketExt> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityBareJid breweryJid;
    private final boolean isSip;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AsyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final Map<Jid, JibriInstance> jibriInstances;
    private static final ExecutorService eventEmitterExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("JibriDetector-AsyncEventEmitter", false));
    private static final Instant NEVER = Instant.MIN;
    @NotNull
    private static final Duration FAILURE_TIMEOUT;
    @NotNull
    private static final Duration SELECT_TIMEOUT;

    /*
     * WARNING - void declaration
     */
    public JibriDetector(@NotNull XmppProvider xmppProvider, @NotNull EntityBareJid breweryJid2, boolean isSip, @NotNull Clock clock) {
        void $this$_init__u24lambda_u240;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)breweryJid2, (String)"breweryJid");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger2 = logger = LoggerExtensionsKt.createLogger$default((Object)Companion, null, null, (int)3, null);
        String string = "http://jitsi.org/protocol/jibri";
        String string2 = "jibri-status";
        EntityBareJid entityBareJid = breweryJid2;
        XmppProvider xmppProvider2 = xmppProvider;
        JibriDetector jibriDetector = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.addContext("type", isSip ? "sip_jibri" : "jibri");
        Unit unit = Unit.INSTANCE;
        super(xmppProvider2, entityBareJid, string2, string, logger);
        this.breweryJid = breweryJid2;
        this.isSip = isSip;
        this.clock = clock;
        ExecutorService executorService = eventEmitterExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"eventEmitterExecutor");
        this.eventEmitter = new AsyncEventEmitter((Executor)executorService);
        this.logger = LoggerExtensionsKt.createLogger$default((Object)((Object)this), null, null, (int)3, null);
        this.xmppConnection = xmppProvider.getXmppConnection();
        this.jibriInstances = new ConcurrentHashMap();
    }

    public /* synthetic */ JibriDetector(XmppProvider xmppProvider, EntityBareJid entityBareJid, boolean bl, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(xmppProvider, entityBareJid, bl, clock);
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AbstractXMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Jid selectJibri() {
        Jid jid;
        Object v0;
        void $this$filterTo$iv$iv;
        Instant now = this.clock.instant();
        Iterable $this$filter$iv = this.jibriInstances.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JibriInstance it = (JibriInstance)element$iv$iv;
            boolean bl = false;
            if (!(it.getReportsAvailable() && Duration.between(it.getLastSelected(), now).compareTo(SELECT_TIMEOUT) >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                JibriInstance it = (JibriInstance)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getLastFailed();
                do {
                    Object e$iv = iterator$iv.next();
                    JibriInstance it2 = (JibriInstance)e$iv;
                    $i$a$-minByOrNull-JibriDetector$selectJibri$oldest$2 = false;
                    Comparable v$iv = it2.getLastFailed();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        JibriInstance jibriInstance = v0;
        if (jibriInstance == null) {
            return null;
        }
        JibriInstance oldest = jibriInstance;
        if (Duration.between(oldest.getLastFailed(), now).compareTo(FAILURE_TIMEOUT) >= 0) {
            Intrinsics.checkNotNull((Object)now);
            oldest.setLastSelected(now);
            jid = oldest.getJid();
        } else {
            jid = null;
        }
        return jid;
    }

    public final void instanceFailed(@NotNull Jid jid) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
            JibriInstance jibriInstance = this.jibriInstances.get(jid);
            if (jibriInstance == null) break block0;
            JibriInstance it = jibriInstance;
            boolean bl = false;
            this.logger.info((Object)("Instance failed: " + jid + ". Will not be selected for the next " + FAILURE_TIMEOUT));
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
            it.setLastFailed(instant);
        }
    }

    protected void onInstanceStatusChanged(@NotNull EntityFullJid jid, @NotNull JibriStatusPacketExt presenceExt) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Intrinsics.checkNotNullParameter((Object)presenceExt, (String)"presenceExt");
        if (!this.jibriInstances.containsKey(jid)) {
            this.logger.info((Object)("Creating a new instance for " + jid + ", available = " + presenceExt.isAvailable()));
            this.jibriInstances.put((Jid)jid, new JibriInstance((Jid)jid, presenceExt.isAvailable()));
        }
        JibriInstance jibriInstance = this.jibriInstances.get(jid);
        if (jibriInstance == null) {
            JibriDetector it = this;
            boolean bl = false;
            this.logger.error((Object)"Instance was removed. Thread safety issues?");
            return;
        }
        JibriInstance jibriInstance2 = jibriInstance;
        jibriInstance2.setReportsAvailable(presenceExt.isAvailable());
        if (jibriInstance2.getReportsAvailable() && !Intrinsics.areEqual((Object)jibriInstance2.getLastFailed(), (Object)NEVER)) {
            this.logger.info((Object)("Resetting failure state for " + jid));
            Instant instant = NEVER;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"NEVER");
            jibriInstance2.setLastFailed(instant);
        }
    }

    protected void notifyInstanceOffline(@NotNull Jid jid) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        this.logger.info((Object)("Removing instance " + jid));
        this.jibriInstances.remove(jid);
        this.eventEmitter.fireEvent((Function1)new Function1<EventHandler, Unit>(jid){
            final /* synthetic */ Jid $jid;
            {
                this.$jid = $jid;
                super(1);
            }

            public final void invoke(@NotNull EventHandler $this$fireEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$fireEvent, (String)"$this$fireEvent");
                $this$fireEvent.instanceOffline(this.$jid);
            }
        });
    }

    public final void addHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.eventEmitter.addHandler((Object)eventHandler);
    }

    public final void removeHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.eventEmitter.removeHandler((Object)eventHandler);
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject debugState = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)debugState).put("is_sip", this.isSip);
        ((Map)debugState).put("brewery_jid", this.breweryJid.toString());
        List list = this.instances;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"instances");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseBrewery.BrewInstance instance = (BaseBrewery.BrewInstance)element$iv;
            boolean bl2 = false;
            Object object = new OrderedJsonObject();
            OrderedJsonObject $this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246 = object;
            boolean bl3 = false;
            Map map = (Map)$this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246;
            String string = "health_status";
            HealthStatusPacketExt healthStatusPacketExt = ((JibriStatusPacketExt)instance.status).getHealthStatus();
            String string2 = String.valueOf(healthStatusPacketExt != null ? healthStatusPacketExt.getStatus() : null);
            map.put(string, string2);
            map = (Map)$this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246;
            string = "busy_status";
            JibriBusyStatusPacketExt jibriBusyStatusPacketExt = ((JibriStatusPacketExt)instance.status).getBusyStatus();
            string2 = String.valueOf(jibriBusyStatusPacketExt != null ? jibriBusyStatusPacketExt.getStatus() : null);
            map.put(string, string2);
            if (this.jibriInstances.get(instance.jid) != null) {
                JibriInstance it;
                boolean bl4 = false;
                ((Map)$this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246).put("reports_available", it.getReportsAvailable());
                Map map2 = (Map)$this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246;
                String string3 = "last_failed";
                String string4 = it.getLastFailed().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String string5 = string4;
                map2.put(string3, string5);
                map2 = (Map)$this$_get_debugState__u24lambda_u248_u24lambda_u247_u24lambda_u246;
                string3 = "last_selected";
                String string6 = it.getLastSelected().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                string5 = string6;
                map2.put(string3, string5);
            }
            OrderedJsonObject instanceJson = object;
            object = (Map)debugState;
            String string7 = instance.jid.getResourcepart().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
            object.put(string7, instanceJson);
        }
        return orderedJsonObject;
    }

    static {
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        FAILURE_TIMEOUT = duration;
        Duration duration2 = Duration.ofMillis(200L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        SELECT_TIMEOUT = duration2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/jibri/JibriDetector$Companion;", "", "()V", "FAILURE_TIMEOUT", "Ljava/time/Duration;", "getFAILURE_TIMEOUT", "()Ljava/time/Duration;", "NEVER", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "SELECT_TIMEOUT", "getSELECT_TIMEOUT", "eventEmitterExecutor", "Ljava/util/concurrent/ExecutorService;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getFAILURE_TIMEOUT() {
            return FAILURE_TIMEOUT;
        }

        @NotNull
        public final Duration getSELECT_TIMEOUT() {
            return SELECT_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/jicofo/jibri/JibriDetector$EventHandler;", "", "instanceOffline", "", "jid", "Lorg/jxmpp/jid/Jid;", "jicofo"})
    public static interface EventHandler {
        public void instanceOffline(@NotNull Jid var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void instanceOffline(@NotNull EventHandler $this, @NotNull Jid jid) {
                Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/jicofo/jibri/JibriDetector$JibriInstance;", "", "jid", "Lorg/jxmpp/jid/Jid;", "reportsAvailable", "", "(Lorg/jxmpp/jid/Jid;Z)V", "getJid", "()Lorg/jxmpp/jid/Jid;", "lastFailed", "Ljava/time/Instant;", "getLastFailed", "()Ljava/time/Instant;", "setLastFailed", "(Ljava/time/Instant;)V", "lastSelected", "getLastSelected", "setLastSelected", "getReportsAvailable", "()Z", "setReportsAvailable", "(Z)V", "jicofo"})
    private static final class JibriInstance {
        @NotNull
        private final Jid jid;
        private boolean reportsAvailable;
        @NotNull
        private Instant lastFailed;
        @NotNull
        private Instant lastSelected;

        public JibriInstance(@NotNull Jid jid, boolean reportsAvailable) {
            Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
            this.jid = jid;
            this.reportsAvailable = reportsAvailable;
            Instant instant = NEVER;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"access$getNEVER$cp(...)");
            this.lastFailed = instant;
            Instant instant2 = NEVER;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"access$getNEVER$cp(...)");
            this.lastSelected = instant2;
        }

        @NotNull
        public final Jid getJid() {
            return this.jid;
        }

        public final boolean getReportsAvailable() {
            return this.reportsAvailable;
        }

        public final void setReportsAvailable(boolean bl) {
            this.reportsAvailable = bl;
        }

        @NotNull
        public final Instant getLastFailed() {
            return this.lastFailed;
        }

        public final void setLastFailed(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastFailed = instant;
        }

        @NotNull
        public final Instant getLastSelected() {
            return this.lastSelected;
        }

        public final void setLastSelected(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastSelected = instant;
        }
    }
}

