/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import java.util.Map;
import java.util.function.Supplier;
import org.jitsi.utils.logging.Logger;
import org.json.simple.JSONObject;

public class TimeSeriesLogger {
    private final Logger logger;

    public static TimeSeriesLogger getTimeSeriesLogger(Class<?> clazz) throws NullPointerException {
        String name = "timeseries." + clazz.getName();
        Logger logger = Logger.getLogger(name);
        return new TimeSeriesLogger(logger);
    }

    private TimeSeriesLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void trace(Map<String, Object> point) {
        if (point != null && !point.isEmpty()) {
            this.logger.trace(new JSONObject(point).toJSONString());
        }
    }

    public void trace(Supplier<Map<String, Object>> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(supplier.get());
        }
    }

    public void warn(Map<String, Object> point) {
        if (point != null && !point.isEmpty()) {
            this.logger.warn(new JSONObject(point).toJSONString());
        }
    }

    public void warn(Supplier<Map<String, Object>> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(supplier.get());
        }
    }

    public void info(Map<String, Object> point) {
        if (point != null && !point.isEmpty()) {
            this.logger.info(new JSONObject(point).toJSONString());
        }
    }

    public void info(Supplier<Map<String, Object>> supplier) {
        if (this.isInfoEnabled()) {
            this.info(supplier.get());
        }
    }
}

