/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ClusterConfigState {
    public static final long NO_OFFSET = -1L;
    public static final ClusterConfigState EMPTY = new ClusterConfigState(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    private final long offset;
    private final Map<String, Integer> connectorTaskCounts;
    private final Map<String, Map<String, String>> connectorConfigs;
    private final Map<String, TargetState> connectorTargetStates;
    private final Map<ConnectorTaskId, Map<String, String>> taskConfigs;
    private final Set<String> inconsistentConnectors;

    public ClusterConfigState(long offset, Map<String, Integer> connectorTaskCounts, Map<String, Map<String, String>> connectorConfigs, Map<String, TargetState> connectorTargetStates, Map<ConnectorTaskId, Map<String, String>> taskConfigs, Set<String> inconsistentConnectors) {
        this.offset = offset;
        this.connectorTaskCounts = connectorTaskCounts;
        this.connectorConfigs = connectorConfigs;
        this.connectorTargetStates = connectorTargetStates;
        this.taskConfigs = taskConfigs;
        this.inconsistentConnectors = inconsistentConnectors;
    }

    public long offset() {
        return this.offset;
    }

    public boolean contains(String connector) {
        return this.connectorConfigs.containsKey(connector);
    }

    public Set<String> connectors() {
        return this.connectorConfigs.keySet();
    }

    public Map<String, String> connectorConfig(String connector) {
        return this.connectorConfigs.get(connector);
    }

    public TargetState targetState(String connector) {
        return this.connectorTargetStates.get(connector);
    }

    public Map<String, String> taskConfig(ConnectorTaskId task) {
        return this.taskConfigs.get(task);
    }

    public List<Map<String, String>> allTaskConfigs(String connector) {
        TreeMap<Integer, Map<String, String>> taskConfigs = new TreeMap<Integer, Map<String, String>>();
        for (Map.Entry<ConnectorTaskId, Map<String, String>> taskConfigEntry : this.taskConfigs.entrySet()) {
            if (!taskConfigEntry.getKey().connector().equals(connector)) continue;
            taskConfigs.put(taskConfigEntry.getKey().task(), taskConfigEntry.getValue());
        }
        return new LinkedList<Map<String, String>>(taskConfigs.values());
    }

    public int taskCount(String connectorName) {
        Integer count = this.connectorTaskCounts.get(connectorName);
        return count == null ? 0 : count;
    }

    public List<ConnectorTaskId> tasks(String connectorName) {
        if (this.inconsistentConnectors.contains(connectorName)) {
            return Collections.emptyList();
        }
        Integer numTasks = this.connectorTaskCounts.get(connectorName);
        if (numTasks == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectorTaskId> taskIds = new ArrayList<ConnectorTaskId>();
        for (int taskIndex = 0; taskIndex < numTasks; ++taskIndex) {
            ConnectorTaskId taskId = new ConnectorTaskId(connectorName, taskIndex);
            taskIds.add(taskId);
        }
        return taskIds;
    }

    public Set<String> inconsistentConnectors() {
        return this.inconsistentConnectors;
    }

    public String toString() {
        return "ClusterConfigState{offset=" + this.offset + ", connectorTaskCounts=" + this.connectorTaskCounts + ", connectorConfigs=" + this.connectorConfigs + ", taskConfigs=" + this.taskConfigs + ", inconsistentConnectors=" + this.inconsistentConnectors + '}';
    }
}

