/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.animation.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class BeanFactory {
    private Map _categories = new HashMap();

    BeanFactory() {
    }

    public void addCategory(String string, String string2, String string3, boolean bl) {
        if (this._categories.get(string) != null) {
            throw new IllegalArgumentException("category name \"" + string + "\" already defined");
        }
        this._categories.put(string, new Category(string, string2, string3, bl));
    }

    public void addPackage(String string, String string2) {
        this.getCategory(string).addPackage(string2);
    }

    public void addPackage(String string, ClassLoader classLoader, String string2) {
        this.getCategory(string).addPackage(classLoader, string2);
    }

    public Object newBean(String string, String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.getCategory(string).newBean(string2);
    }

    private Category getCategory(String string) {
        Category category = (Category)this._categories.get(string);
        if (category != null) {
            return category;
        }
        throw new IllegalArgumentException("no category named \"" + string + "\"");
    }

    private static class Category {
        private String _name;
        private List _packages = new ArrayList();
        private String _prefix;
        private String _postfix;
        private boolean _capitalise;

        Category(String string, String string2, String string3, boolean bl) {
            this._name = string;
            this._prefix = string2;
            this._postfix = string3;
            this._capitalise = bl;
        }

        public void addPackage(ClassLoader classLoader, String string) {
            this._packages.add(new Package(classLoader, string));
        }

        public void addPackage(String string) {
            this._packages.add(new Package(string));
        }

        Object newBean(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            String string2 = this._prefix + Character.toUpperCase(string.charAt(0)) + string.substring(1) + this._postfix;
            Iterator iterator = this._packages.iterator();
            while (iterator.hasNext()) {
                Class clazz = ((Package)iterator.next()).loadClass(string2);
                if (clazz == null) continue;
                return clazz.newInstance();
            }
            throw new ClassNotFoundException("no class found for " + this._name + " bean of type \"" + string + "\"");
        }
    }

    private static class Package {
        private ClassLoader _loader;
        private String _package;

        public Package(ClassLoader classLoader, String string) {
            this._loader = classLoader;
            this._package = string;
        }

        public Package(String string) {
            this(ClassLoader.getSystemClassLoader(), string);
        }

        public Class loadClass(String string) {
            String string2 = this._package + "." + string;
            try {
                return this._loader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

