// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
// $Id: getrf.cc,v 1.3 2002/07/05 03:02:15 llee Exp $
//


#include <complex>
#include "mtl/mtl2lapack.h"
#include "mtl/dense1D.h"
#include "mtl/utils.h"


/*
  Sample Output

  A:
  3x3
  [
  [1,2,2],
  [2,1,2],
  [2,2,1]
  ]
  b:
  3x1
  [
  [15],
  [15],
  [15]
  ]
  x:
  3x1
  [
  [3],
  [3],
  [3]
  ]

  */


int
main()
{
  using namespace mtl2lapack;
  using namespace mtl;

  const int M = 3;
  const int N = 3;
  const int NRHS = 1;
  //begin
  double da [] = { 1, 2, 2, 2, 1, 2, 2, 2, 1 };
  lapack_matrix<double,external>::type A(da, M, N);
  lapack_matrix<double>::type B(M*NRHS, NRHS);
  mtl::set_value(B, 15.0);
  dense1D<int> pivot(N, 0);
  //end
  std::cout << "A:" << std::endl;
  print_all_matrix(A);

  std::cout << "b:" << std::endl;
  print_all_matrix(B);

  // Factor A, solve the system, and print the solution.
  //begin
  int info = getrf(A, pivot);
  //end
  print_all_matrix(A);

  std::cout << "pivots" << std::endl;
  print_vector(pivot);
  //begin
  if (info == 0) {
    info = getrs('N', A, pivot, B);

    if (info == 0) {
      std::cout << "x:" << std::endl;
      print_all_matrix(B);
    } else
      std::cout << "Factorization failed with INFO = " << info << std::endl;
  } else
    std::cout << "Solve failed with INFO = " << info << std::endl;
  //end
  return 0;
}
