/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.svg.Metadata;
import java.util.Vector;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LNode;
import net.claribole.zvtm.glyphs.DPathST;

class LEdge
extends LElem {
    static final short UNDIRECTED = 0;
    static final short INCOMING = 1;
    static final short OUTGOING = 2;
    static final String UNDIRECTED_STR = "--";
    static final String DIRECTED_STR = "->";
    boolean directed = false;
    LNode tail;
    LNode head;

    LEdge(String title, Vector glyphs) {
        int i;
        this.title = title;
        this.glyphs = new Glyph[glyphs.size()];
        this.URLs = new String[glyphs.size()];
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = (Glyph)glyphs.elementAt(i);
            if (this.glyphs[i].getOwner() == null) continue;
            this.URLs[i] = ((Metadata)this.glyphs[i].getOwner()).getURL();
        }
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].setOwner(this);
        }
    }

    String getURL(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.URLs[i];
        }
        return null;
    }

    void setDirected(boolean b) {
        this.directed = b;
    }

    boolean isDirected() {
        return this.directed;
    }

    boolean isLoop() {
        return this.tail == this.head;
    }

    void setTail(LNode n) {
        this.tail = n;
        if (this.tail != null) {
            this.tail.addArc(this, this.directed ? (short)2 : 0);
        }
    }

    void setHead(LNode n) {
        this.head = n;
        if (this.head != null) {
            this.head.addArc(this, this.directed ? (short)1 : 0);
        }
    }

    LNode getTail() {
        return this.tail;
    }

    LNode getHead() {
        return this.head;
    }

    LNode getOtherEnd(LNode n) {
        return n == this.tail ? this.head : this.tail;
    }

    DPathST getSpline() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!(this.glyphs[i] instanceof DPathST)) continue;
            return (DPathST)this.glyphs[i];
        }
        return null;
    }

    public String toString() {
        return this.title + "@" + this.hashCode() + " [" + (this.tail != null ? this.tail.getTitle() + "@" + this.tail.hashCode() : "NULL") + (this.directed ? DIRECTED_STR : UNDIRECTED_STR) + (this.head != null ? this.head.getTitle() + "@" + this.head.hashCode() : "NULL") + "]";
    }
}

