/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.BooleanOps;
import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import net.claribole.zvtm.glyphs.projection.ProjBoolean;

public class VBoolShape
extends ClosedShape
implements RectangularShape {
    BooleanOps[] booleanShapes;
    long szx;
    long szy;
    int shapeType;
    ProjBoolean[] pc;

    public VBoolShape(long x, long y, int z, long sx, long sy, int st, BooleanOps[] b, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.szx = sx;
        this.szy = sy;
        this.shapeType = st;
        this.booleanShapes = b;
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VBoolShape(long x, long y, int z, long sx, long sy, int st, BooleanOps[] b, Color c, Color bc) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.szx = sx;
        this.szy = sy;
        this.shapeType = st;
        this.booleanShapes = b;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjBoolean[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjBoolean();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjBoolean[] ta = this.pc;
                this.pc = new ProjBoolean[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjBoolean();
            } else {
                System.err.println("VBoolShape:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjBoolean[1];
            this.pc[0] = new ProjBoolean();
        } else {
            System.err.println("VBoolShape:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return 0.0f;
    }

    public void sizeTo(float radius) {
    }

    public void setWidth(long w) {
    }

    public void setHeight(long h) {
    }

    public long getWidth() {
        return this.szx / 2L;
    }

    public long getHeight() {
        return this.szy / 2L;
    }

    public void reSize(float factor) {
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].mainArea.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].mainArea.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        for (j = 0; j < this.booleanShapes.length; ++j) {
            this.booleanShapes[j].project(this.coef, this.pc[i].cx, this.pc[i].cy);
        }
        this.pc[i].cszx = (float)this.szx * this.coef;
        this.pc[i].cszy = (float)this.szy * this.coef;
        switch (this.shapeType) {
            case 1: {
                this.pc[i].mainArea = new Area(new Ellipse2D.Float((float)this.pc[i].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].cy - (float)(this.szy / 2L) * this.coef, this.pc[i].cszx, this.pc[i].cszy));
                break;
            }
            case 2: {
                this.pc[i].mainArea = new Area(new Rectangle2D.Float((float)this.pc[i].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].cy - (float)(this.szy / 2L) * this.coef, this.pc[i].cszx, this.pc[i].cszy));
                break;
            }
            default: {
                this.pc[i].mainArea = new Area(new Ellipse2D.Float((float)this.pc[i].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].cy - (float)(this.szy / 2L) * this.coef, this.pc[i].cszx, this.pc[i].cszy));
            }
        }
        block11: for (j = 0; j < this.booleanShapes.length; ++j) {
            switch (this.booleanShapes[j].opType) {
                case 1: {
                    this.pc[i].mainArea.add(this.booleanShapes[j].ar);
                    continue block11;
                }
                case 2: {
                    this.pc[i].mainArea.subtract(this.booleanShapes[j].ar);
                    continue block11;
                }
                case 3: {
                    this.pc[i].mainArea.intersect(this.booleanShapes[j].ar);
                    continue block11;
                }
                case 4: {
                    this.pc[i].mainArea.exclusiveOr(this.booleanShapes[j].ar);
                    continue block11;
                }
                default: {
                    System.err.println("Error: VBoolShape: boolean operation not defined");
                }
            }
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].cx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].cy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        for (j = 0; j < this.booleanShapes.length; ++j) {
            this.booleanShapes[j].projectForLens(this.coef, this.pc[i].lcx, this.pc[i].lcy);
        }
        this.pc[i].lcszx = (float)this.szx * this.coef;
        this.pc[i].lcszy = (float)this.szy * this.coef;
        switch (this.shapeType) {
            case 1: {
                this.pc[i].lmainArea = new Area(new Ellipse2D.Float((float)this.pc[i].lcx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].lcy - (float)(this.szy / 2L) * this.coef, this.pc[i].lcszx, this.pc[i].lcszy));
                break;
            }
            case 2: {
                this.pc[i].lmainArea = new Area(new Rectangle2D.Float((float)this.pc[i].lcx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].lcy - (float)(this.szy / 2L) * this.coef, this.pc[i].lcszx, this.pc[i].lcszy));
                break;
            }
            default: {
                this.pc[i].lmainArea = new Area(new Ellipse2D.Float((float)this.pc[i].lcx - (float)(this.szx / 2L) * this.coef, (float)this.pc[i].lcy - (float)(this.szy / 2L) * this.coef, this.pc[i].lcszx, this.pc[i].lcszy));
            }
        }
        block11: for (j = 0; j < this.booleanShapes.length; ++j) {
            switch (this.booleanShapes[j].opType) {
                case 1: {
                    this.pc[i].lmainArea.add(this.booleanShapes[j].lar);
                    continue block11;
                }
                case 2: {
                    this.pc[i].lmainArea.subtract(this.booleanShapes[j].lar);
                    continue block11;
                }
                case 3: {
                    this.pc[i].lmainArea.intersect(this.booleanShapes[j].lar);
                    continue block11;
                }
                case 4: {
                    this.pc[i].lmainArea.exclusiveOr(this.booleanShapes[j].lar);
                    continue block11;
                }
                default: {
                    System.err.println("Error: VBoolShape: boolean operation not defined");
                }
            }
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].mainArea.getBounds().width > 2 && this.pc[i].mainArea.getBounds().height > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fill(this.pc[i].mainArea);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.draw(this.pc[i].mainArea);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.draw(this.pc[i].mainArea);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lmainArea.getBounds().width > 2 && this.pc[i].lmainArea.getBounds().height > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fill(this.pc[i].lmainArea);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.draw(this.pc[i].lmainArea);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.draw(this.pc[i].lmainArea);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public int getMainShapeType() {
        return this.shapeType;
    }

    public BooleanOps[] getOperations() {
        return this.booleanShapes;
    }

    public Object clone() {
        return new VBoolShape(this.vx, this.vy, 0, this.szx, this.szy, this.shapeType, this.booleanShapes, this.color);
    }
}

