/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.opensolaris.opengrok.configuration.Project;

public class ExpandTabsReader
extends FilterReader {
    private final int tabSize;
    private int pos;
    private int spacesToInsert;

    ExpandTabsReader(Reader in, int tabSize) {
        super(in);
        this.tabSize = tabSize;
    }

    public static Reader wrap(Reader in, Project p) {
        if (p != null && p.hasTabSizeSetting()) {
            return new ExpandTabsReader(in, p.getTabSize());
        }
        return in;
    }

    @Override
    public int read() throws IOException {
        if (this.spacesToInsert > 0) {
            ++this.pos;
            --this.spacesToInsert;
            return 32;
        }
        int c = super.read();
        if (c == 9) {
            int spaces = this.tabSize - this.pos % this.tabSize;
            ++this.pos;
            this.spacesToInsert = spaces - 1;
            return 32;
        }
        this.pos = c == 10 || c == 13 ? 0 : ++this.pos;
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i > 0 ? i : -1;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int c;
        if (n < 0L) {
            throw new IllegalArgumentException("n is negative");
        }
        long skipped = 0L;
        for (long l = 0L; l < n && (c = this.read()) != -1; ++l) {
            ++skipped;
        }
        return skipped;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

