/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Document;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.Ctags;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.HistoryAnalyzer;
import org.opensolaris.opengrok.analysis.PathTokenizer;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.plain.PlainFullTokenizer;
import org.opensolaris.opengrok.analysis.plain.PlainSymbolTokenizer;
import org.opensolaris.opengrok.configuration.Project;

public class FileAnalyzer
extends Analyzer {
    protected Project project;
    private final FileAnalyzerFactory factory;
    protected Ctags ctags;

    public void setCtags(Ctags ctags) {
        this.ctags = ctags;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public final FileAnalyzerFactory getFactory() {
        return this.factory;
    }

    public Genre getGenre() {
        return this.factory.getGenre();
    }

    public FileAnalyzer(FileAnalyzerFactory factory) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.factory = factory;
    }

    public String getFileTypeName() {
        String suffix;
        String name = ((Object)((Object)this)).getClass().getSimpleName().toLowerCase();
        if (name.endsWith(suffix = "analyzer")) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name.toLowerCase();
    }

    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
    }

    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        switch (fieldName) {
            case "full": {
                return new Analyzer.TokenStreamComponents((Tokenizer)new PlainFullTokenizer(reader));
            }
            case "path": 
            case "project": {
                return new Analyzer.TokenStreamComponents((Tokenizer)new PathTokenizer(reader));
            }
            case "hist": {
                return new HistoryAnalyzer().createComponents(fieldName, reader);
            }
            case "refs": 
            case "defs": {
                return new Analyzer.TokenStreamComponents((Tokenizer)new PlainSymbolTokenizer(reader));
            }
        }
        OpenGrokLogger.getLogger().log(Level.WARNING, "Have no analyzer for: {0}", fieldName);
        return null;
    }

    public static enum Genre {
        PLAIN("p"),
        XREFABLE("x"),
        IMAGE("i"),
        DATA("d"),
        HTML("h");

        private String typeName;

        private Genre(String typename) {
            this.typeName = typename;
        }

        public String typeName() {
            return this.typeName;
        }

        public static Genre get(String typeName) {
            if (typeName == null) {
                return null;
            }
            for (Genre g : Genre.values()) {
                if (!g.typeName.equals(typeName)) continue;
                return g;
            }
            return null;
        }
    }
}

