/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class RepoRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.repo";
    public static final String CMD_FALLBACK = "repo";

    public RepoRepository() {
        this.type = CMD_FALLBACK;
        this.setWorking(Boolean.TRUE);
    }

    @Override
    public boolean isWorking() {
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        return true;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.getDirectoryName());
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("sync");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, ".repo");
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    @Override
    boolean supportsSubRepositories() {
        return true;
    }

    @Override
    boolean fileHasHistory(File file) {
        return false;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return false;
    }

    @Override
    History getHistory(File file) {
        throw new UnsupportedOperationException("Should never be called!");
    }

    @Override
    InputStream getHistoryGet(String parent, String basename, String rev) {
        throw new UnsupportedOperationException("Should never be called!");
    }

    @Override
    boolean fileHasAnnotation(File file) {
        return false;
    }

    @Override
    Annotation annotate(File file, String revision) {
        throw new UnsupportedOperationException("Should never be called!");
    }
}

