require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_MBUF_H_)) {
    eval 'sub _SYS_MBUF_H_ () {1;}' unless defined(&_SYS_MBUF_H_);
    if(defined(&_KERNEL_OPT)) {
	require './sys/opt_mbuftrace.ph';
    }
    unless(defined(&M_WAITOK)) {
	require 'sys/malloc.ph';
    }
    require 'sys/pool.ph';
    require 'sys/queue.ph';
    if(defined(&_KERNEL)) {
	require 'sys/percpu_types.ph';
	require 'sys/socket.ph';
	require 'sys/psref.ph';
    }
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	require 'sys/systm.ph';
    } else {
	require 'stddef.ph';
    }
    require 'uvm/uvm_param.ph';
    require 'net/if.ph';
    eval 'sub MOWNER_INIT {
        my($x, $y) = @_;
	    eval q({ . &mo_name = $x, . &mo_descr = $y });
    }' unless defined(&MOWNER_INIT);
    eval("sub MOWNER_COUNTER_CLAIMS () { 0; }") unless defined(&MOWNER_COUNTER_CLAIMS);
    eval("sub MOWNER_COUNTER_RELEASES () { 1; }") unless defined(&MOWNER_COUNTER_RELEASES);
    eval("sub MOWNER_COUNTER_CLUSTER_CLAIMS () { 2; }") unless defined(&MOWNER_COUNTER_CLUSTER_CLAIMS);
    eval("sub MOWNER_COUNTER_CLUSTER_RELEASES () { 3; }") unless defined(&MOWNER_COUNTER_CLUSTER_RELEASES);
    eval("sub MOWNER_COUNTER_EXT_CLAIMS () { 4; }") unless defined(&MOWNER_COUNTER_EXT_CLAIMS);
    eval("sub MOWNER_COUNTER_EXT_RELEASES () { 5; }") unless defined(&MOWNER_COUNTER_EXT_RELEASES);
    eval("sub MOWNER_COUNTER_NCOUNTERS () { 6; }") unless defined(&MOWNER_COUNTER_NCOUNTERS);
    if(defined(&_KERNEL)) {
    }
    eval 'sub mtod {
        my($m, $t) = @_;
	    eval q((($t)(($m)-> &m_data)));
    }' unless defined(&mtod);
    eval 'sub rcvif_index () { ($_rcvif->{index});}' unless defined(&rcvif_index);
    eval 'sub PKTHDR_FLAG_IPSEC_SKIP_PFIL () {0x1;}' unless defined(&PKTHDR_FLAG_IPSEC_SKIP_PFIL);
    eval 'sub M_CSUM_TCPv4 () {0x1;}' unless defined(&M_CSUM_TCPv4);
    eval 'sub M_CSUM_UDPv4 () {0x2;}' unless defined(&M_CSUM_UDPv4);
    eval 'sub M_CSUM_TCP_UDP_BAD () {0x4;}' unless defined(&M_CSUM_TCP_UDP_BAD);
    eval 'sub M_CSUM_DATA () {0x8;}' unless defined(&M_CSUM_DATA);
    eval 'sub M_CSUM_TCPv6 () {0x10;}' unless defined(&M_CSUM_TCPv6);
    eval 'sub M_CSUM_UDPv6 () {0x20;}' unless defined(&M_CSUM_UDPv6);
    eval 'sub M_CSUM_IPv4 () {0x40;}' unless defined(&M_CSUM_IPv4);
    eval 'sub M_CSUM_IPv4_BAD () {0x80;}' unless defined(&M_CSUM_IPv4_BAD);
    eval 'sub M_CSUM_TSOv4 () {0x100;}' unless defined(&M_CSUM_TSOv4);
    eval 'sub M_CSUM_TSOv6 () {0x200;}' unless defined(&M_CSUM_TSOv6);
    eval 'sub M_CSUM_BLANK () {0x40000000;}' unless defined(&M_CSUM_BLANK);
    eval 'sub M_CSUM_NO_PSEUDOHDR () {0x80000000;}' unless defined(&M_CSUM_NO_PSEUDOHDR);
    eval 'sub M_CSUM_BITS () {"\\20\\1TCPv4\\2UDPv4\\3TCP_UDP_BAD\\4DATA\\5TCPv6\\6UDPv6\\7IPv4\\10IPv4_BAD" "\\11TSOv4\\12TSOv6\\37BLANK\\40NO_PSEUDOHDR";}' unless defined(&M_CSUM_BITS);
    eval 'sub M_CSUM_DATA_IPv4_IPHL {
        my($x) = @_;
	    eval q((($x) >> 16));
    }' unless defined(&M_CSUM_DATA_IPv4_IPHL);
    eval 'sub M_CSUM_DATA_IPv4_OFFSET {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&M_CSUM_DATA_IPv4_OFFSET);
    eval 'sub M_CSUM_DATA_IPv6_IPHL {
        my($x) = @_;
	    eval q((($x) >> 16));
    }' unless defined(&M_CSUM_DATA_IPv6_IPHL);
    eval 'sub M_CSUM_DATA_IPv6_OFFSET {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&M_CSUM_DATA_IPv6_OFFSET);
    eval 'sub M_CSUM_DATA_IPv6_SET {
        my($x, $v) = @_;
	    eval q(($x) = (($x) & 0xffff) | (($v) << 16));
    }' unless defined(&M_CSUM_DATA_IPv6_SET);
    if(defined(&MIN_PAGE_SIZE)) {
	eval 'sub M_EXT_MAXPAGES () {((65536/  &MIN_PAGE_SIZE) + 1);}' unless defined(&M_EXT_MAXPAGES);
    }
    if(defined(&M_EXT_MAXPAGES)) {
    }
    eval 'sub ext_paddr () { ($ext_un->{extun_paddr});}' unless defined(&ext_paddr);
    eval 'sub ext_pgs () { ($ext_un->{extun_pgs});}' unless defined(&ext_pgs);
    eval 'sub M_PADDR_INVALID () { &POOL_PADDR_INVALID;}' unless defined(&M_PADDR_INVALID);
    eval 'sub MBUF_DEFINE {
        my($name, $mhlen, $mlen) = @_;
	    eval q(\'struct name\' { \'struct m_hdr\'  &m_hdr; \'union union\' { \'struct struct\' { \'struct pkthdr\'  &MH_pkthdr; \'union union\' { \'struct _m_ext\'  &MH_ext; \'char\'  $MH_databuf[($mhlen)]; }  &MH_dat; }  &MH; \'char\'  $M_databuf[($mlen)]; }  &M_dat; });
    }' unless defined(&MBUF_DEFINE);
    eval 'sub m_next () { ($m_hdr->{mh_next});}' unless defined(&m_next);
    eval 'sub m_len () { ($m_hdr->{mh_len});}' unless defined(&m_len);
    eval 'sub m_data () { ($m_hdr->{mh_data});}' unless defined(&m_data);
    eval 'sub m_owner () { ($m_hdr->{mh_owner});}' unless defined(&m_owner);
    eval 'sub m_type () { ($m_hdr->{mh_type});}' unless defined(&m_type);
    eval 'sub m_flags () { ($m_hdr->{mh_flags});}' unless defined(&m_flags);
    eval 'sub m_nextpkt () { ($m_hdr->{mh_nextpkt});}' unless defined(&m_nextpkt);
    eval 'sub m_paddr () { ($m_hdr->{mh_paddr});}' unless defined(&m_paddr);
    eval 'sub m_pkthdr () { ($M_dat->{MH}->{MH_pkthdr});}' unless defined(&m_pkthdr);
    eval 'sub m_ext_storage () { ($M_dat->{MH}->{MH_dat}->{MH_ext}->{ext_storage});}' unless defined(&m_ext_storage);
    eval 'sub m_ext_ref () { ($M_dat->{MH}->{MH_dat}->{MH_ext}->{ext_ref});}' unless defined(&m_ext_ref);
    eval 'sub m_ext () { ($m_ext_ref->{m_ext_storage});}' unless defined(&m_ext);
    eval 'sub m_pktdat () { ($M_dat->{MH}->{MH_dat}->{MH_databuf});}' unless defined(&m_pktdat);
    eval 'sub m_dat () { ($M_dat->{M_databuf});}' unless defined(&m_dat);
    eval 'sub MLEN () {(( &MSIZE -  &offsetof(\'struct _mbuf_dummy\',  &m_dat)));}' unless defined(&MLEN);
    eval 'sub MHLEN () {(( &MSIZE -  &offsetof(\'struct _mbuf_dummy\',  &m_pktdat)));}' unless defined(&MHLEN);
    eval 'sub MINCLSIZE () {( &MHLEN+ &MLEN+1);}' unless defined(&MINCLSIZE);
    eval 'sub M_EXT () {0x1;}' unless defined(&M_EXT);
    eval 'sub M_PKTHDR () {0x2;}' unless defined(&M_PKTHDR);
    eval 'sub M_EOR () {0x4;}' unless defined(&M_EOR);
    eval 'sub M_PROTO1 () {0x8;}' unless defined(&M_PROTO1);
    eval 'sub M_AUTHIPHDR () {0x10;}' unless defined(&M_AUTHIPHDR);
    eval 'sub M_DECRYPTED () {0x20;}' unless defined(&M_DECRYPTED);
    eval 'sub M_LOOP () {0x40;}' unless defined(&M_LOOP);
    eval 'sub M_BCAST () {0x100;}' unless defined(&M_BCAST);
    eval 'sub M_MCAST () {0x200;}' unless defined(&M_MCAST);
    eval 'sub M_CANFASTFWD () {0x400;}' unless defined(&M_CANFASTFWD);
    eval 'sub M_ANYCAST6 () {0x800;}' unless defined(&M_ANYCAST6);
    eval 'sub M_LINK0 () {0x1000;}' unless defined(&M_LINK0);
    eval 'sub M_LINK1 () {0x2000;}' unless defined(&M_LINK1);
    eval 'sub M_LINK2 () {0x4000;}' unless defined(&M_LINK2);
    eval 'sub M_LINK3 () {0x8000;}' unless defined(&M_LINK3);
    eval 'sub M_LINK4 () {0x10000;}' unless defined(&M_LINK4);
    eval 'sub M_LINK5 () {0x20000;}' unless defined(&M_LINK5);
    eval 'sub M_LINK6 () {0x40000;}' unless defined(&M_LINK6);
    eval 'sub M_LINK7 () {0x80000;}' unless defined(&M_LINK7);
    eval 'sub M_VLANTAG () {0x100000;}' unless defined(&M_VLANTAG);
    eval 'sub M_EXT_FLAGS () {0xff000000;}' unless defined(&M_EXT_FLAGS);
    eval 'sub M_EXT_CLUSTER () {0x1000000;}' unless defined(&M_EXT_CLUSTER);
    eval 'sub M_EXT_PAGES () {0x2000000;}' unless defined(&M_EXT_PAGES);
    eval 'sub M_EXT_ROMAP () {0x4000000;}' unless defined(&M_EXT_ROMAP);
    eval 'sub M_EXT_RW () {0x8000000;}' unless defined(&M_EXT_RW);
    eval 'sub M_NOTIFICATION () { &M_PROTO1;}' unless defined(&M_NOTIFICATION);
    eval 'sub M_FLAGS_BITS () {"\\20\\1EXT\\2PKTHDR\\3EOR\\4PROTO1\\5AUTHIPHDR\\6DECRYPTED\\7LOOP\\10NONE" "\\11BCAST\\12MCAST\\13CANFASTFWD\\14ANYCAST6\\15LINK0\\16LINK1\\17LINK2\\20LINK3" "\\21LINK4\\22LINK5\\23LINK6\\24LINK7" "\\25VLANTAG" "\\31EXT_CLUSTER\\32EXT_PAGES\\33EXT_ROMAP\\34EXT_RW";}' unless defined(&M_FLAGS_BITS);
    eval 'sub M_COPYFLAGS () {( &M_PKTHDR| &M_EOR| &M_BCAST| &M_MCAST| &M_CANFASTFWD|  &M_ANYCAST6| &M_LINK0| &M_LINK1| &M_LINK2| &M_AUTHIPHDR| &M_DECRYPTED| &M_LOOP|  &M_VLANTAG);}' unless defined(&M_COPYFLAGS);
    eval 'sub M_EXTCOPYFLAGS () {( &M_EXT| &M_EXT_FLAGS);}' unless defined(&M_EXTCOPYFLAGS);
    eval 'sub MT_FREE () {0;}' unless defined(&MT_FREE);
    eval 'sub MT_DATA () {1;}' unless defined(&MT_DATA);
    eval 'sub MT_HEADER () {2;}' unless defined(&MT_HEADER);
    eval 'sub MT_SONAME () {3;}' unless defined(&MT_SONAME);
    eval 'sub MT_SOOPTS () {4;}' unless defined(&MT_SOOPTS);
    eval 'sub MT_FTABLE () {5;}' unless defined(&MT_FTABLE);
    eval 'sub MT_CONTROL () {6;}' unless defined(&MT_CONTROL);
    eval 'sub MT_OOBDATA () {7;}' unless defined(&MT_OOBDATA);
    if(defined(&MBUFTYPES)) {
    } else {
    }
    eval 'sub M_DONTWAIT () { &M_NOWAIT;}' unless defined(&M_DONTWAIT);
    eval 'sub M_WAIT () { &M_WAITOK;}' unless defined(&M_WAIT);
    if(defined(&MBUFTRACE)) {
    } else {
	eval 'sub mowner_init_owner {
	    my($mo, $n, $d) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_init_owner);
	eval 'sub mowner_init {
	    my($m, $type) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_init);
	eval 'sub mowner_ref {
	    my($m, $flags) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_ref);
	eval 'sub mowner_revoke {
	    my($m, $all, $flags) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_revoke);
	eval 'sub m_claim {
	    my($m, $mowner) = @_;
    	    eval q( &__nothing);
	}' unless defined(&m_claim);
	eval 'sub mowner_attach {
	    my($mo) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_attach);
	eval 'sub mowner_detach {
	    my($mo) = @_;
    	    eval q( &__nothing);
	}' unless defined(&mowner_detach);
	eval 'sub m_claimm {
	    my($m, $mo) = @_;
    	    eval q( &__nothing);
	}' unless defined(&m_claimm);
    }
    eval 'sub MCLAIM {
        my($m, $mo) = @_;
	    eval q( &m_claim(($m), ($mo)));
    }' unless defined(&MCLAIM);
    eval 'sub MOWNER_ATTACH {
        my($mo) = @_;
	    eval q( &mowner_attach($mo));
    }' unless defined(&MOWNER_ATTACH);
    eval 'sub MOWNER_DETACH {
        my($mo) = @_;
	    eval q( &mowner_detach($mo));
    }' unless defined(&MOWNER_DETACH);
    eval 'sub MGET {
        my($m, $how, $type) = @_;
	    eval q($m =  &m_get(($how), ($type)));
    }' unless defined(&MGET);
    eval 'sub MGETHDR {
        my($m, $how, $type) = @_;
	    eval q($m =  &m_gethdr(($how), ($type)));
    }' unless defined(&MGETHDR);
    if(defined(&_KERNEL)) {
	eval 'sub MCLINITREFERENCE {
	    my($m) = @_;
    	    eval q( &do {  &KASSERT((($m)-> &m_flags &  &M_EXT) == 0); ($m)-> &m_ext_ref = ($m); ($m)-> ($m_ext->{ext_refcnt}) = 1; }  &while (0));
	}' unless defined(&MCLINITREFERENCE);
	eval 'sub MCLGET {
	    my($m, $how) = @_;
    	    eval q( &m_clget(($m), ($how)));
	}' unless defined(&MCLGET);
	eval 'sub MEXTMALLOC {
	    my($m, $size, $how) = @_;
    	    eval q( &do { ($m)-> ($m_ext_storage->{ext_buf}) =  &malloc(($size), 0, ($how));  &if (($m)-> ($m_ext_storage->{ext_buf}) !=  &NULL) {  &MCLINITREFERENCE($m); ($m)-> &m_data = ($m)-> ($m_ext->{ext_buf}); ($m)-> &m_flags = (($m)-> &m_flags & ~ &M_EXTCOPYFLAGS) |  &M_EXT| &M_EXT_RW; ($m)-> ($m_ext->{ext_size}) = ($size); ($m)-> ($m_ext->{ext_free}) =  &NULL; ($m)-> ($m_ext->{ext_arg}) =  &NULL;  &mowner_ref(($m),  &M_EXT); } }  &while (0));
	}' unless defined(&MEXTMALLOC);
	eval 'sub MEXTADD {
	    my($m, $buf, $size, $type, $free, $arg) = @_;
    	    eval q( &do {  &MCLINITREFERENCE; -> &m_data = -> ($m_ext->{ext_buf}) = ($buf); ($m)-> &m_flags = (($m)-> &m_flags & ~ &M_EXTCOPYFLAGS) |  &M_EXT; ($m)-> ($m_ext->{ext_size}) = ($size); ($m)-> ($m_ext->{ext_free}) = ($free); ($m)-> ($m_ext->{ext_arg}) = ($arg);  &mowner_ref(($m),  &M_EXT); }  &while (0));
	}' unless defined(&MEXTADD);
	eval 'sub M_BUFADDR {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags &  &M_EXT) ? ($m)-> ($m_ext->{ext_buf}) : (($m)-> &m_flags &  &M_PKTHDR) ? ($m)-> &m_pktdat : ($m)-> &m_dat));
	}' unless defined(&M_BUFADDR);
	eval 'sub M_BUFSIZE {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags &  &M_EXT) ? ($m)-> ($m_ext->{ext_size}) : (($m)-> &m_flags &  &M_PKTHDR) ?  &MHLEN :  &MLEN));
	}' unless defined(&M_BUFSIZE);
	eval 'sub MRESETDATA {
	    my($m) = @_;
    	    eval q(($m)-> &m_data =  &M_BUFADDR($m));
	}' unless defined(&MRESETDATA);
	eval 'sub M_BUFOFFSET {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags &  &M_PKTHDR) ?  &offsetof(\'struct mbuf\',  &m_pktdat) :  &offsetof(\'struct mbuf\',  &m_dat)));
	}' unless defined(&M_BUFOFFSET);
	eval 'sub M_READONLY {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags &  &M_EXT) != 0 && ((($m)-> &m_flags & ( &M_EXT_ROMAP| &M_EXT_RW)) !=  &M_EXT_RW || ($m)-> ($m_ext->{ext_refcnt}) > 1)));
	}' unless defined(&M_READONLY);
	eval 'sub M_UNWRITABLE {
	    my($__m, $__len) = @_;
    	    eval q((($__m)-> &m_len < ($__len) ||  &M_READONLY(($__m))));
	}' unless defined(&M_UNWRITABLE);
	eval 'sub M_ROMAP {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags & ( &M_EXT| &M_EXT_ROMAP)) == ( &M_EXT| &M_EXT_ROMAP)));
	}' unless defined(&M_ROMAP);
	eval 'sub M_LEADINGSPACE {
	    my($m) = @_;
    	    eval q(( &M_READONLY(($m)) ? 0: (($m)-> &m_data -  &M_BUFADDR($m))));
	}' unless defined(&M_LEADINGSPACE);
	eval 'sub _M_TRAILINGSPACE {
	    my($m) = @_;
    	    eval q((($m)-> &m_flags &  &M_EXT ? ($m)-> ($m_ext->{ext_buf}) + ($m)-> ($m_ext->{ext_size}) - (($m)-> &m_data + ($m)-> &m_len) : ($m)-> $m_dat[ &MLEN] - (($m)-> &m_data + ($m)-> &m_len)));
	}' unless defined(&_M_TRAILINGSPACE);
	eval 'sub M_TRAILINGSPACE {
	    my($m) = @_;
    	    eval q(( &M_READONLY(($m)) ? 0:  &_M_TRAILINGSPACE(($m))));
	}' unless defined(&M_TRAILINGSPACE);
	eval 'sub M_PREPEND {
	    my($m, $plen, $how) = @_;
    	    eval q( &do {  &if ( &M_LEADINGSPACE($m) >= ($plen)) { ($m)-> &m_data -= ($plen); ($m)-> &m_len += ($plen); }  &else ($m) =  &m_prepend(($m), ($plen), ($how));  &if (($m)  && ($m)-> &m_flags &  &M_PKTHDR) ($m)-> ($m_pkthdr->{len}) += ($plen); }  &while (0));
	}' unless defined(&M_PREPEND);
	eval 'sub MCHTYPE {
	    my($m, $t) = @_;
    	    eval q( &do {  &KASSERT(($t) !=  &MT_FREE);  &mbstat_type_add(($m)-> &m_type, -1);  &mbstat_type_add($t, 1); ($m)-> &m_type = $t; }  &while (0));
	}' unless defined(&MCHTYPE);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub M_VERIFY_PACKET {
	        my($m) = @_;
    		eval q( &m_verify_packet($m));
	    }' unless defined(&M_VERIFY_PACKET);
	} else {
	    eval 'sub M_VERIFY_PACKET {
	        my($m) = @_;
    		eval q( &__nothing);
	    }' unless defined(&M_VERIFY_PACKET);
	}
	eval 'sub M_COPYALL () {-1;}' unless defined(&M_COPYALL);
	eval 'sub M_GETCTX {
	    my($m, $t) = @_;
    	    eval q((($t)($m)-> ($m_pkthdr->{_rcvif}->{c$tx})));
	}' unless defined(&M_GETCTX);
	eval 'sub M_SETCTX {
	    my($m, $c) = @_;
    	    eval q((( &void)(($m)-> ($m_pkthdr->{_rcvif}->{ctx}) = ( &void *)($c))));
	}' unless defined(&M_SETCTX);
	eval 'sub M_CLEARCTX {
	    my($m) = @_;
    	    eval q( &M_SETCTX(($m),  &NULL));
	}' unless defined(&M_CLEARCTX);
	eval 'sub M_REGION_GET {
	    my($val, $typ, $m, $off, $len) = @_;
    	    eval q( &do { \'struct mbuf\' * &_t; \'int\'  &_tmp;  &if (($m)-> &m_len >= ($off) + ($len)) ($val) = ($typ)( &mtod(($m), \'char\' *) + ($off));  &else {  &_t =  &m_pulldown(($m), ($off), ($len), & &_tmp);  &if ( &_t) {  &if ( ($_t->{m_len}) <  &_tmp + ($len))  &panic(\\"m_pulldown malfunction\\"); ($val) = ($typ)( &mtod( &_t, \'char\' *) +  &_tmp); }  &else { ($val) = ($typ) &NULL; ($m) =  &NULL; } } }  &while (0));
	}' unless defined(&M_REGION_GET);
    }
    eval 'sub MBUFQ_HEAD {
        my($name) = @_;
	    eval q(\'struct name\' { \'struct mbuf\' * &mq_first; \'struct mbuf\' ** &mq_last; });
    }' unless defined(&MBUFQ_HEAD);
    eval 'sub MBUFQ_INIT {
        my($q) = @_;
	    eval q( &do { ($q)-> &mq_first =  &NULL; ($q)-> &mq_last = ($q)-> &mq_first; }  &while (0));
    }' unless defined(&MBUFQ_INIT);
    eval 'sub MBUFQ_ENQUEUE {
        my($q, $m) = @_;
	    eval q( &do { ($m)-> &m_nextpkt =  &NULL; *($q)-> &mq_last = ($m); ($q)-> &mq_last = ($m)-> &m_nextpkt; }  &while (0));
    }' unless defined(&MBUFQ_ENQUEUE);
    eval 'sub MBUFQ_PREPEND {
        my($q, $m) = @_;
	    eval q( &do {  &if ((($m)-> &m_nextpkt = ($q)-> &mq_first) ==  &NULL) ($q)-> &mq_last = ($m)-> &m_nextpkt; ($q)-> &mq_first = ($m); }  &while (0));
    }' unless defined(&MBUFQ_PREPEND);
    eval 'sub MBUFQ_DEQUEUE {
        my($q, $m) = @_;
	    eval q( &do {  &if ((($m) = ($q)-> &mq_first) !=  &NULL) {  &if ((($q)-> &mq_first = ($m)-> &m_nextpkt) ==  &NULL) ($q)-> &mq_last = ($q)-> &mq_first;  &else ($m)-> &m_nextpkt =  &NULL; } }  &while (0));
    }' unless defined(&MBUFQ_DEQUEUE);
    eval 'sub MBUFQ_DRAIN {
        my($q) = @_;
	    eval q( &do { \'struct mbuf\' * &__m0;  &while (( &__m0 = ($q)-> &mq_first) !=  &NULL) { ($q)-> &mq_first =  ($__m0->{m_nextpkt});  &m_freem( &__m0); } ($q)-> &mq_last = ($q)-> &mq_first; }  &while (0));
    }' unless defined(&MBUFQ_DRAIN);
    eval 'sub MBUFQ_FIRST {
        my($q) = @_;
	    eval q((($q)-> &mq_first));
    }' unless defined(&MBUFQ_FIRST);
    eval 'sub MBUFQ_NEXT {
        my($m) = @_;
	    eval q((($m)-> &m_nextpkt));
    }' unless defined(&MBUFQ_NEXT);
    eval 'sub MBUFQ_LAST {
        my($q) = @_;
	    eval q((*($q)-> &mq_last));
    }' unless defined(&MBUFQ_LAST);
    eval 'sub MBUF_MSIZE () {1;}' unless defined(&MBUF_MSIZE);
    eval 'sub MBUF_MCLBYTES () {2;}' unless defined(&MBUF_MCLBYTES);
    eval 'sub MBUF_NMBCLUSTERS () {3;}' unless defined(&MBUF_NMBCLUSTERS);
    eval 'sub MBUF_MBLOWAT () {4;}' unless defined(&MBUF_MBLOWAT);
    eval 'sub MBUF_MCLLOWAT () {5;}' unless defined(&MBUF_MCLLOWAT);
    eval 'sub MBUF_STATS () {6;}' unless defined(&MBUF_STATS);
    eval 'sub MBUF_MOWNERS () {7;}' unless defined(&MBUF_MOWNERS);
    eval 'sub MBUF_NMBCLUSTERS_LIMIT () {8;}' unless defined(&MBUF_NMBCLUSTERS_LIMIT);
    if(defined(&_KERNEL)) {
	if(defined(&MBUFTRACE)) {
	}
	eval 'sub PACKET_TAG_NONE () {0;}' unless defined(&PACKET_TAG_NONE);
	eval 'sub PACKET_TAG_SO () {4;}' unless defined(&PACKET_TAG_SO);
	eval 'sub PACKET_TAG_NPF () {10;}' unless defined(&PACKET_TAG_NPF);
	eval 'sub PACKET_TAG_PF () {11;}' unless defined(&PACKET_TAG_PF);
	eval 'sub PACKET_TAG_ALTQ_QID () {12;}' unless defined(&PACKET_TAG_ALTQ_QID);
	eval 'sub PACKET_TAG_IPSEC_OUT_DONE () {18;}' unless defined(&PACKET_TAG_IPSEC_OUT_DONE);
	eval 'sub PACKET_TAG_IPSEC_NAT_T_PORTS () {25;}' unless defined(&PACKET_TAG_IPSEC_NAT_T_PORTS);
	eval 'sub PACKET_TAG_INET6 () {26;}' unless defined(&PACKET_TAG_INET6);
	eval 'sub PACKET_TAG_TUNNEL_INFO () {28;}' unless defined(&PACKET_TAG_TUNNEL_INFO);
	eval 'sub PACKET_TAG_MPLS () {29;}' unless defined(&PACKET_TAG_MPLS);
	eval 'sub PACKET_TAG_SRCROUTE () {30;}' unless defined(&PACKET_TAG_SRCROUTE);
	eval 'sub PACKET_TAG_ETHERNET_SRC () {31;}' unless defined(&PACKET_TAG_ETHERNET_SRC);
	eval 'sub m_set_rcvif {
	    my($m,$ifp) = @_;
    	    eval q({  &KASSERT( ($m->{m_flags}) &  &M_PKTHDR);  ($m->{m_pkthdr}->{rcvif_index}) =  ($ifp->{if_index}); });
	}' unless defined(&m_set_rcvif);
	eval 'sub m_reset_rcvif {
	    my($m) = @_;
    	    eval q({  &KASSERT( ($m->{m_flags}) &  &M_PKTHDR);  ($m->{m_pkthdr}->{_rcvif}->{ctx}) =  &NULL; });
	}' unless defined(&m_reset_rcvif);
	eval 'sub m_copy_rcvif {
	    my($m,$n) = @_;
    	    eval q({  &KASSERT( ($m->{m_flags}) &  &M_PKTHDR);  &KASSERT( ($n->{m_flags}) &  &M_PKTHDR);  ($m->{m_pkthdr}->{rcvif_index}) =  ($n->{m_pkthdr}->{rcvif_index}); });
	}' unless defined(&m_copy_rcvif);
	eval 'sub M_GET_ALIGNED_HDR {
	    my($m, $type, $linkhdr) = @_;
    	    eval q( &m_get_aligned_hdr(($m),  &__alignof($type) - 1, $sizeof{$type}, ($linkhdr)));
	}' unless defined(&M_GET_ALIGNED_HDR);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub m_get_aligned_hdr {
	    my($m,$mask,$hlen,$linkhdr) = @_;
    	    eval q({  &if ( &__predict_false((*$m)-> &m_len < $hlen)) *$m =  &m_pullup(*$m, $hlen); *$m ==  &NULL; });
	}' unless defined(&m_get_aligned_hdr);
	eval 'sub m_put_rcvif {
	    my($ifp,$s) = @_;
    	    eval q({  &if ($ifp ==  &NULL) ;  &pserialize_read_exit(*$s); });
	}' unless defined(&m_put_rcvif);
	eval 'sub m_put_rcvif_psref {
	    my($ifp,$psref) = @_;
    	    eval q({  &if ($ifp ==  &NULL) ;  &if_put($ifp, $psref); });
	}' unless defined(&m_put_rcvif_psref);
    }
}
1;
