/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.BrowserDialog;
import org.parosproxy.paros.extension.history.EmbeddedBrowser;
import org.parosproxy.paros.extension.history.HistoryFilterDialog;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.extension.history.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.history.PopupMenuDeleteHistory;
import org.parosproxy.paros.extension.history.PopupMenuEmbeddedBrowser;
import org.parosproxy.paros.extension.history.PopupMenuExportMessage;
import org.parosproxy.paros.extension.history.PopupMenuExportResponse;
import org.parosproxy.paros.extension.history.PopupMenuPurgeHistory;
import org.parosproxy.paros.extension.history.PopupMenuResend;
import org.parosproxy.paros.extension.history.PopupMenuTag;
import org.parosproxy.paros.extension.history.ProxyListenerLog;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;

public class ExtensionHistory
extends ExtensionAdaptor
implements SessionChangedListener {
    private static final int FILTER_NONE = 0;
    private static final int FILTER_REQUEST = 1;
    private static final int FILTER_RESPONSE = 2;
    private LogPanel logPanel = null;
    private ProxyListenerLog proxyListener = null;
    private HistoryList historyList = null;
    private String filter = "";
    private EmbeddedBrowser browser = null;
    private static BrowserDialog browserDialog = null;
    private HistoryFilterDialog filterDialog = null;
    private JCheckBoxMenuItem menuFilterHistoryByRequest = null;
    private JCheckBoxMenuItem menuFilterHistoryByResponse = null;
    private int stateFilter = 0;
    private PopupMenuDeleteHistory popupMenuDeleteHistory = null;
    private PopupMenuPurgeHistory popupMenuPurgeHistory = null;
    private PopupMenuResend popupMenuResend = null;
    private ManualRequestEditorDialog resendDialog = null;
    private PopupMenuExportMessage popupMenuExportMessage = null;
    private PopupMenuExportMessage popupMenuExportMessage2 = null;
    private PopupMenuExportResponse popupMenuExportResponse = null;
    private PopupMenuExportResponse popupMenuExportResponse2 = null;
    private PopupMenuEmbeddedBrowser popupMenuEmbeddedBrowser = null;
    private PopupMenuEmbeddedBrowser popupMenuEmbeddedBrowser2 = null;
    private PopupMenuTag popupMenuTag = null;
    private static Pattern patternWindows = Pattern.compile("window", 2);

    public ExtensionHistory() {
        this.initialize();
    }

    public ExtensionHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionHistory");
    }

    LogPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new LogPanel();
            this.logPanel.setName("History");
            this.logPanel.setExtension(this);
        }
        return this.logPanel;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        extensionHook.addProxyListener(this.getProxyListenerLog());
        if (this.getView() != null) {
            ExtensionHookView extensionHookView = extensionHook.getHookView();
            extensionHookView.addStatusPanel(this.getLogPanel());
            this.getLogPanel().setDisplayPanel(this.getView().getRequestPanel(), this.getView().getResponsePanel());
            extensionHook.getHookMenu().addViewMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addViewMenuItem(this.getMenuFilterHistoryByRequest());
            extensionHook.getHookMenu().addViewMenuItem(this.getMenuFilterHistoryByResponse());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuResend());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuTag());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuEmbeddedBrowser());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuDeleteHistory());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuPurgeHistory());
            extensionHook.getHookMenu().addFileMenuItem(this.getPopupMenuExportMessage2());
            extensionHook.getHookMenu().addFileMenuItem(this.getPopupMenuExportResponse2());
            if (ExtensionHistory.isEnableForNativePlatform()) {
                this.getBrowserDialog();
            }
        }
    }

    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionHistory.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        this.getHistoryList().clear();
        this.getLogPanel().getListLog().setModel(this.getHistoryList());
        this.getView().getRequestPanel().setMessage("", "", true);
        this.getView().getResponsePanel().setMessage("", "", false);
        try {
            Vector vector = this.getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), 1);
            this.buildHistory(this.getHistoryList(), vector);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ProxyListenerLog getProxyListenerLog() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerLog(this.getModel(), this.getView(), this.getHistoryList());
        }
        return this.proxyListener;
    }

    public HistoryList getHistoryList() {
        if (this.historyList == null) {
            this.historyList = new HistoryList();
        }
        return this.historyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchHistory(String string, boolean bl) {
        Session session = this.getModel().getSession();
        HistoryList historyList = this.historyList;
        synchronized (historyList) {
            try {
                List list = this.getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), 1, string, bl);
                this.buildHistory(this.getHistoryList(), list);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHistory(HistoryList historyList, List list) {
        HistoryReference historyReference = null;
        HistoryList historyList2 = historyList;
        synchronized (historyList2) {
            historyList.clear();
            for (int i = 0; i < list.size(); ++i) {
                int n = (Integer)list.get(i);
                try {
                    historyReference = new HistoryReference(n);
                    historyList.addElement(historyReference);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private HistoryFilterDialog getFilterDialog() {
        if (this.filterDialog == null) {
            this.filterDialog = new HistoryFilterDialog((Frame)this.getView().getMainFrame(), true);
        }
        return this.filterDialog;
    }

    private JCheckBoxMenuItem getMenuFilterHistoryByRequest() {
        if (this.menuFilterHistoryByRequest == null) {
            this.menuFilterHistoryByRequest = new JCheckBoxMenuItem();
            this.menuFilterHistoryByRequest.setText("Filter History by Request...");
            this.menuFilterHistoryByRequest.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExtensionHistory.this.showFilterDialog(true);
                    switch (n) {
                        case -1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 0;
                            break;
                        }
                        case 0: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            if (ExtensionHistory.this.stateFilter == 1) {
                                ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                                break;
                            }
                            if (ExtensionHistory.this.stateFilter != 2) break;
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            break;
                        }
                        case 1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 1;
                        }
                    }
                }
            });
        }
        return this.menuFilterHistoryByRequest;
    }

    private int showFilterDialog(boolean bl) {
        HistoryFilterDialog historyFilterDialog = this.getFilterDialog();
        historyFilterDialog.setModal(true);
        int n = historyFilterDialog.showDialog();
        int n2 = 0;
        if (n == 0) {
            this.filter = historyFilterDialog.getPattern();
            this.getProxyListenerLog().setFilter(this.filter);
            this.searchHistory(this.filter, bl);
            n2 = 1;
        } else if (n == 1) {
            this.filter = "";
            this.getProxyListenerLog().setFilter(this.filter);
            this.searchHistory(this.filter, bl);
            n2 = -1;
        }
        return n2;
    }

    private JCheckBoxMenuItem getMenuFilterHistoryByResponse() {
        if (this.menuFilterHistoryByResponse == null) {
            this.menuFilterHistoryByResponse = new JCheckBoxMenuItem();
            this.menuFilterHistoryByResponse.setText("Filter History by Response...");
            this.menuFilterHistoryByResponse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExtensionHistory.this.showFilterDialog(false);
                    switch (n) {
                        case -1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 0;
                            break;
                        }
                        case 0: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            if (ExtensionHistory.this.stateFilter == 1) {
                                ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                                break;
                            }
                            if (ExtensionHistory.this.stateFilter != 2) break;
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            break;
                        }
                        case 1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            ExtensionHistory.this.stateFilter = 2;
                        }
                    }
                }
            });
        }
        return this.menuFilterHistoryByResponse;
    }

    private PopupMenuDeleteHistory getPopupMenuDeleteHistory() {
        if (this.popupMenuDeleteHistory == null) {
            this.popupMenuDeleteHistory = new PopupMenuDeleteHistory();
            this.popupMenuDeleteHistory.setExtension(this);
        }
        return this.popupMenuDeleteHistory;
    }

    private PopupMenuPurgeHistory getPopupMenuPurgeHistory() {
        if (this.popupMenuPurgeHistory == null) {
            this.popupMenuPurgeHistory = new PopupMenuPurgeHistory();
            this.popupMenuPurgeHistory.setExtension(this);
        }
        return this.popupMenuPurgeHistory;
    }

    private PopupMenuResend getPopupMenuResend() {
        if (this.popupMenuResend == null) {
            this.popupMenuResend = new PopupMenuResend();
            this.popupMenuResend.setExtension(this);
        }
        return this.popupMenuResend;
    }

    ManualRequestEditorDialog getResendDialog() {
        if (this.resendDialog == null) {
            this.resendDialog = new ManualRequestEditorDialog((Frame)this.getView().getMainFrame(), false, false, this);
            this.resendDialog.setSize(500, 600);
            this.resendDialog.setTitle("Resend");
        }
        return this.resendDialog;
    }

    private PopupMenuExportMessage getPopupMenuExportMessage() {
        if (this.popupMenuExportMessage == null) {
            this.popupMenuExportMessage = new PopupMenuExportMessage();
            this.popupMenuExportMessage.setExtension(this);
        }
        return this.popupMenuExportMessage;
    }

    private PopupMenuExportMessage getPopupMenuExportMessage2() {
        if (this.popupMenuExportMessage2 == null) {
            this.popupMenuExportMessage2 = new PopupMenuExportMessage();
            this.popupMenuExportMessage2.setExtension(this);
        }
        return this.popupMenuExportMessage2;
    }

    private PopupMenuExportResponse getPopupMenuExportResponse() {
        if (this.popupMenuExportResponse == null) {
            this.popupMenuExportResponse = new PopupMenuExportResponse();
            this.popupMenuExportResponse.setExtension(this);
        }
        return this.popupMenuExportResponse;
    }

    private PopupMenuExportResponse getPopupMenuExportResponse2() {
        if (this.popupMenuExportResponse2 == null) {
            this.popupMenuExportResponse2 = new PopupMenuExportResponse();
            this.popupMenuExportResponse2.setExtension(this);
        }
        return this.popupMenuExportResponse2;
    }

    private PopupMenuEmbeddedBrowser getPopupMenuEmbeddedBrowser() {
        if (this.popupMenuEmbeddedBrowser == null) {
            this.popupMenuEmbeddedBrowser = new PopupMenuEmbeddedBrowser();
            this.popupMenuEmbeddedBrowser.setExtension(this);
        }
        return this.popupMenuEmbeddedBrowser;
    }

    private PopupMenuEmbeddedBrowser getPopupMenuEmbeddedBrowser2() {
        if (this.popupMenuEmbeddedBrowser2 == null) {
            this.popupMenuEmbeddedBrowser2 = new PopupMenuEmbeddedBrowser();
            this.popupMenuEmbeddedBrowser2.setExtension(this);
        }
        return this.popupMenuEmbeddedBrowser2;
    }

    private PopupMenuTag getPopupMenuTag() {
        if (this.popupMenuTag == null) {
            this.popupMenuTag = new PopupMenuTag();
            this.popupMenuTag.setExtension(this);
        }
        return this.popupMenuTag;
    }

    boolean browserDisplay(HistoryReference historyReference, HttpMessage httpMessage) {
        boolean bl = false;
        String string = httpMessage.getResponseHeader().getHeader("Content-Type");
        if (string != null) {
            if (string.indexOf("text/html") >= 0 || string.indexOf("text/plain") >= 0) {
                bl = true;
            } else if (httpMessage.getResponseHeader().isImage()) {
                bl = true;
            } else if (string.indexOf("application/pdf") >= 0) {
                bl = true;
            }
        }
        if (!bl) {
            return bl;
        }
        try {
            if (!this.getBrowserDialog().isVisible()) {
                this.getBrowserDialog().setVisible(true);
            }
            this.browser = this.getBrowserDialog().getEmbeddedBrowser();
            this.browser.stop();
            this.browser.setVisible(true);
            CacheProcessingItem cacheProcessingItem = new CacheProcessingItem(historyReference, httpMessage);
            Proxy proxy = Control.getSingleton().getProxy();
            proxy.setEnableCacheProcessing(true);
            proxy.addCacheProcessingList(cacheProcessingItem);
            this.getBrowserDialog().setURLTitle(httpMessage.getRequestHeader().getURI().toString());
            if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
                this.browser.setURL(new URL(httpMessage.getRequestHeader().getURI().toString()), httpMessage.getRequestBody().toString());
            } else {
                this.browser.setURL(new URL(httpMessage.getRequestHeader().getURI().toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    BrowserDialog getBrowserDialog() {
        if (browserDialog == null) {
            browserDialog = new BrowserDialog((Frame)this.getView().getMainFrame(), false);
        }
        return browserDialog;
    }

    static boolean isEnableForNativePlatform() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternWindows.matcher(string);
        return matcher.find();
    }
}

