/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{lll as i}from"@typo3/core/lit-helper.js";import{SeverityEnum as f}from"@typo3/backend/enum/severity.js";import s from"@typo3/core/ajax/ajax-request.js";import c from"@typo3/backend/notification.js";import g from"@typo3/backend/modal.js";import m from"@typo3/backend/hashing/md5.js";import{fileListOpenElementBrowser as b}from"@typo3/filelist/file-list.js";import{FileListActionUtility as p,FileListActionEvent as U}from"@typo3/filelist/file-list-actions.js";class l{static getReturnUrl(){return encodeURIComponent(top.list_frame.document.location.pathname+top.list_frame.document.location.search)}static triggerFileDownload(o,n,e=!1){const t=document.createElement("a");t.href=o,t.download=n,document.body.appendChild(t),t.click(),e&&URL.revokeObjectURL(o),document.body.removeChild(t),c.success(i("file_download.success"),"",2)}static renameFile(o,n,e){(async()=>{await import("@typo3/filelist/file-list-rename-handler.js");const t=p.createResourceFromContextDataset(e),r={event:null,trigger:null,action:U.rename,resources:[t],url:null,originalAction:null};document.dispatchEvent(new CustomEvent(U.rename,{detail:r}))})()}static replaceFile(o,n,e){const t=p.createResourceFromContextDataset(e),r=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(r+"&target="+encodeURIComponent(t.identifier)+"&uid="+encodeURIComponent(t.uid)+"&returnUrl="+l.getReturnUrl())}static editFile(o,n,e){const t=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(t+"&target="+encodeURIComponent(n)+"&returnUrl="+l.getReturnUrl())}static editMetadata(o,n,e){const t=p.createResourceFromContextDataset(e);t.metaUid&&top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FormEngine.moduleUrl+"&edit[sys_file_metadata]["+t.metaUid+"]=edit&returnUrl="+l.getReturnUrl())}static openInfoPopUp(o,n){o==="sys_file_storage"?top.TYPO3.InfoWindow.showItem(o,n):top.TYPO3.InfoWindow.showItem("_FILE",n)}static uploadFile(o,n,e){const t=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(t+"&target="+encodeURIComponent(n)+"&returnUrl="+l.getReturnUrl())}static createFolder(o,n,e){top.TYPO3.Backend.ContentContainer.get().document.dispatchEvent(new CustomEvent(b,{detail:{actionUrl:e.actionUrl,identifier:e.identifier,mode:e.mode}}))}static createFile(o,n,e){const t=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(t+"&target="+encodeURIComponent(n)+"&returnUrl="+l.getReturnUrl())}static downloadFile(o,n,e){l.triggerFileDownload(e.url,e.name)}static downloadFolder(o,n,e){c.info(i("file_download.prepare"),"",2);const t=e.actionUrl;new s(t).post({items:[n]}).then(async r=>{let a=r.response.headers.get("Content-Disposition");if(!a){const d=await r.resolve();d.success===!1&&d.status?c.warning(i("file_download."+d.status),i("file_download."+d.status+".message"),10):c.error(i("file_download.error"));return}a=a.substring(a.indexOf(" filename=")+10);const u=await r.raw().arrayBuffer(),C=new Blob([u],{type:r.raw().headers.get("Content-Type")});l.triggerFileDownload(URL.createObjectURL(C),a,!0)}).catch(()=>{c.error(i("file_download.error"))})}static createFilemount(o,n){n.split(":").length===2&&top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FormEngine.moduleUrl+"&edit[sys_filemounts][0]=new&defVals[sys_filemounts][identifier]="+encodeURIComponent(n)+"&returnUrl="+l.getReturnUrl())}static deleteFile(o,n,e){const t=()=>{top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FileCommit.moduleUrl+"&data[delete][0][data]="+encodeURIComponent(n)+"&data[delete][0][redirect]="+l.getReturnUrl())};if(!e.title){t();return}const r=g.confirm(e.title,e.message,f.warning,[{text:e.buttonCloseText||TYPO3.lang["button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:e.buttonOkText||TYPO3.lang["button.delete"]||"Delete",btnClass:"btn-warning",name:"delete"}]);r.addEventListener("button.clicked",a=>{a.target.name==="delete"&&t(),r.hideModal()})}static copyFile(o,n){const e=m.hash(n),t=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:n},setCopyMode:"1"}};new s(t).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static copyReleaseFile(o,n){const e=m.hash(n),t=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:"0"},setCopyMode:"1"}};new s(t).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static cutFile(o,n){const e=m.hash(n),t=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:n}}};new s(t).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static cutReleaseFile(o,n){const e=m.hash(n),t=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:"0"}}};new s(t).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static pasteFileInto(o,n,e){const t=()=>{top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FileCommit.moduleUrl+"&CB[paste]=FILE|"+encodeURIComponent(n)+"&CB[pad]=normal&redirect="+l.getReturnUrl())};if(!e.title){t();return}const r=g.confirm(e.title,e.message,f.warning,[{text:e.buttonCloseText||TYPO3.lang["button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:e.buttonOkText||TYPO3.lang["button.ok"]||"OK",btnClass:"btn-warning",name:"ok"}]);r.addEventListener("button.clicked",a=>{a.target.name==="ok"&&t(),r.hideModal()})}static updateOnlineMedia(o,n,e){if(!e.actionUrl||!e.filecontextUid||e.filecontextType!=="file")return;const t={resource:{type:e.filecontextType,uid:e.filecontextUid}};new s(e.actionUrl).post(t).then(()=>{c.success(i("online_media.update.success"))}).catch(()=>{c.error(i("online_media.update.error"))}).finally(()=>{window.location.reload()})}}export{l as default};
