/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionView;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DatabaseSessionToolWindowHelper
extends SessionToolWindowHelper {
    public static final String SESSION_TOOLWINDOW_ID = DatabaseMessages.message((String)"jdbc.console.tab.title", (Object[])new Object[0]);
    static final DatabaseSessionToolWindowHelper INSTANCE = new DatabaseSessionToolWindowHelper();
    private static final Map<Project, ConsoleToolWindowStateTracker> ourTrackers = ContainerUtil.newIdentityHashMap();

    DatabaseSessionToolWindowHelper() {
        super(SESSION_TOOLWINDOW_ID, DatabaseIcons.ToolWindowConsole);
    }

    @Override
    protected void setup(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
        if (project == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(1);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        MyAutoScrollFromHandler scrollFromHandler = new MyAutoScrollFromHandler(project, toolWindow);
        MyAutoScrollToHandler scrollToHandler = new MyAutoScrollToHandler(project, toolWindow);
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)scrollFromHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)scrollFromHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll to Editor", (Getter<Boolean>)((Getter)scrollToHandler::isAutoScrollMode), (Setter<Boolean>)((Setter)scrollToHandler::setAutoScrollMode)));
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        ScrollFromEditorAction scrollFromEditorAction = new ScrollFromEditorAction(scrollFromHandler);
        toolWindow.setTitleActions(new AnAction[]{scrollFromEditorAction});
        DatabaseSessionToolWindowHelper.installToolWindowManagerListener(project);
    }

    private static void installToolWindowManagerListener(@NotNull Project project) {
        ConsoleToolWindowStateTracker listener;
        ConsoleToolWindowStateTracker old;
        if (project == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(2);
        }
        if ((old = ourTrackers.put(project, listener = new ConsoleToolWindowStateTracker(project))) != null) {
            Disposer.dispose((Disposable)old);
        }
        Disposer.register((Disposable)project, (Disposable)listener);
        project.getMessageBus().connect((Disposable)listener).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy(@NotNull Project project, @NotNull ToolWindow w, @NotNull ToolWindowManager manager) {
        if (project == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(3);
        }
        if (w == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(5);
        }
        try {
            super.destroy(project, w, manager);
        }
        finally {
            DatabaseSessionToolWindowHelper.stopTrackToolWindowState(project);
        }
    }

    public static void stopTrackToolWindowState(@NotNull Project project) {
        ConsoleToolWindowStateTracker listener;
        if (project == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(6);
        }
        if ((listener = ourTrackers.get(project)) != null) {
            Disposer.dispose((Disposable)listener);
        }
    }

    public static boolean wasActiveLastTime(@NotNull Project project) {
        if (project == null) {
            DatabaseSessionToolWindowHelper.$$$reportNull$$$0(7);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean("database.console.LAST_STATE", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/session/DatabaseSessionToolWindowHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installToolWindowManagerListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "destroy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "stopTrackToolWindowState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "wasActiveLastTime";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConsoleToolWindowStateTracker
    implements Disposable,
    ToolWindowManagerListener {
        private static final String PROPERTY_LAST_CONSOLE_STATE = "database.console.LAST_STATE";
        private final Project myProject;

        ConsoleToolWindowStateTracker(@NotNull Project project) {
            if (project == null) {
                ConsoleToolWindowStateTracker.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void stateChanged() {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(SESSION_TOOLWINDOW_ID);
            PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
            properties.setValue(PROPERTY_LAST_CONSOLE_STATE, String.valueOf(window != null && window.isVisible()));
        }

        public void dispose() {
            ourTrackers.remove(this.myProject, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/session/DatabaseSessionToolWindowHelper$ConsoleToolWindowStateTracker", "<init>"));
        }
    }

    private static class ScrollFromEditorAction
    extends DumbAwareAction {
        private final MyAutoScrollFromHandler myScrollFromHandler;

        ScrollFromEditorAction(MyAutoScrollFromHandler scrollFromHandler) {
            super("Scroll from Editor", "Select console open in the active editor", AllIcons.General.Locate);
            this.myScrollFromHandler = scrollFromHandler;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ScrollFromEditorAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] editors = manager.getSelectedEditors();
            if (editors.length == 0) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!this.myScrollFromHandler.select(editor)) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/session/DatabaseSessionToolWindowHelper$ScrollFromEditorAction", "actionPerformed"));
        }
    }

    private static class MyAutoScrollToHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_TO_SOURCE";
        private final Project myProject;
        private boolean myEnabled;
        private boolean myToolwindowVisible;

        MyAutoScrollToHandler(final @NotNull Project project, final @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            final ContentManager contentManager = toolWindow.getContentManager();
            contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!myToolwindowVisible) {
                        return;
                    }
                    if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        TransactionGuard.submitTransaction((Disposable)project, () -> {
                            if (event == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            this.selectContentEditor(event.getContent());
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseSessionToolWindowHelper$MyAutoScrollToHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "selectionChanged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$selectionChanged$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myProject.getMessageBus().connect((Disposable)contentManager).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

                public void stateChanged() {
                    Content content;
                    if (toolWindow.isVisible() && !myToolwindowVisible && (content = contentManager.getSelectedContent()) != null) {
                        TransactionGuard.submitTransaction((Disposable)project, () -> this.selectContentEditor(content));
                    }
                    myToolwindowVisible = toolWindow.isVisible();
                }
            });
        }

        protected boolean isAutoScrollMode() {
            return this.myEnabled;
        }

        protected void setAutoScrollMode(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        private void selectContentEditor(@NotNull Content content) {
            Object[] clients;
            if (content == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(2);
            }
            if (!this.myEnabled || !this.myProject.isOpen()) {
                return;
            }
            FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
            VirtualFile currentFile = manager.getCurrentFile();
            VisibleDatabaseSessionClient currentClient = currentFile == null ? null : DatabaseEditorHelper.findClient(currentFile, (FileEditorManager)manager);
            DatabaseSession session2 = DatabaseSessionManager.findSession(content);
            Object[] objectArray = clients = session2 == null ? new VisibleDatabaseSessionClient[]{} : session2.getVisibleClients();
            if (session2 == null || clients.length == 0 || ArrayUtil.contains((Object)currentClient, (Object[])clients)) {
                return;
            }
            VirtualFile virtualFile = clients[0].getVirtualFile();
            if (manager.isFileOpen(virtualFile)) {
                manager.openFile(virtualFile, false, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/session/DatabaseSessionToolWindowHelper$MyAutoScrollToHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectContentEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAutoScrollFromHandler
    extends AutoScrollFromSourceHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_FROM_SOURCE";
        private boolean myEnabled;

        MyAutoScrollFromHandler(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(1);
            }
            super(project, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            this.install();
        }

        protected boolean isAutoScrollEnabled() {
            return this.myEnabled;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(2);
            }
            this.select(editor);
        }

        boolean select(@NotNull FileEditor editor) {
            DatabaseSessionView view;
            FileEditorManagerEx manager;
            VirtualFile virtualFile;
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(3);
            }
            if ((virtualFile = (manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject)).getFile(editor)) == null) {
                return false;
            }
            VisibleDatabaseSessionClient client = DatabaseEditorHelper.findClient(virtualFile, (FileEditorManager)manager);
            VisibleDatabaseSession session2 = client == null ? null : (VisibleDatabaseSession)client.getSession();
            DatabaseSessionView databaseSessionView = view = session2 != null ? (DatabaseSessionView)session2.getView() : null;
            if (view != null && view.isToolWindowContentPresent()) {
                view.show(true, false);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/session/DatabaseSessionToolWindowHelper$MyAutoScrollFromHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

